/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.control;

import borland.jbcl.util.BlackBox;
import com.sun.java.swing.JComponent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.Serializable;

public class TextControl
extends JComponent
implements Serializable,
BlackBox {
    protected String text;
    protected Color edgeColor = Color.black;
    protected boolean drawEdge = false;
    protected boolean transparent = true;
    protected int alignment = 33;
    protected Insets margins;

    public TextControl() {
        this.setSize(150, 20);
    }

    public TextControl(String string) {
        this.text = string;
        this.setSize(150, 20);
    }

    public void setText(String string) {
        this.text = string;
        this.repaint(100L);
    }

    public String getText() {
        return this.text;
    }

    public void setAlignment(int n) {
        this.alignment = n;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setMargins(Insets insets) {
        this.margins = insets;
    }

    public Insets getMargins() {
        return this.margins;
    }

    public void setTransparent(boolean bl) {
        this.transparent = bl;
        this.repaint(100L);
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void setEdgeColor(Color color) {
        this.edgeColor = color;
        this.repaint(100L);
    }

    public Color getEdgeColor() {
        return this.edgeColor;
    }

    public void setDrawEdge(boolean bl) {
        this.drawEdge = bl;
        this.repaint(100L);
    }

    public boolean isDrawEdge() {
        return this.drawEdge;
    }

    public Dimension getPreferredSize() {
        Graphics graphics = this.getGraphics();
        if (graphics == null || this.text == null || this.text.equals("")) {
            return new Dimension(150, 20);
        }
        Font font = this.getFont();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        Insets insets = this.margins != null ? this.margins : new Insets(0, 0, 0, 0);
        return new Dimension(insets.left + insets.right + fontMetrics.stringWidth(this.text), insets.top + insets.bottom + fontMetrics.getHeight());
    }

    public void update(Graphics graphics) {
        boolean bl = this.transparent;
        this.transparent = false;
        this.paint(graphics);
        this.transparent = bl;
    }

    public void paintComponent(Graphics graphics) {
        Insets insets;
        super.paintComponent(graphics);
        Dimension dimension = this.getSize();
        graphics.clipRect(0, 0, dimension.width, dimension.height);
        Color color = graphics.getColor();
        Font font = graphics.getFont();
        Insets insets2 = insets = this.margins != null ? this.margins : new Insets(0, 0, 0, 0);
        if (!this.transparent) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
        if (this.text != null && !this.text.equals("")) {
            int n;
            Font font2 = this.getFont();
            graphics.setFont(font2);
            FontMetrics fontMetrics = graphics.getFontMetrics(font2);
            switch (this.alignment & 0xF) {
                default: {
                    n = insets.left;
                    break;
                }
                case 2: {
                    n = (dimension.width - fontMetrics.stringWidth(this.text)) / 2;
                    break;
                }
                case 3: {
                    n = dimension.width - fontMetrics.stringWidth(this.text) - insets.right;
                }
            }
            switch (this.alignment & 0xF0) {
                default: {
                    int n2 = insets.top;
                    break;
                }
                case 32: {
                    int n2 = (dimension.height - fontMetrics.getHeight()) / 2;
                    break;
                }
                case 48: {
                    int n2 = dimension.height - insets.bottom - fontMetrics.getHeight();
                }
            }
            graphics.setColor(this.getForeground());
            graphics.drawString(this.text, n, n2 += fontMetrics.getLeading() + fontMetrics.getAscent());
        }
        if (this.drawEdge) {
            graphics.setColor(this.edgeColor);
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        }
        graphics.setFont(font);
        graphics.setColor(color);
    }
}

