/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.layout;

import borland.jbcl.layout.XYConstraints;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Hashtable;

public class XYLayout
implements LayoutManager2,
Serializable {
    private static final long serialVersionUID = 200L;
    int width;
    int height;
    Hashtable info = new Hashtable();
    static final XYConstraints defaultConstraints = new XYConstraints();

    public XYLayout() {
    }

    public XYLayout(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public String toString() {
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf("XYLayout[width=").concat(String.valueOf(this.width))).concat(String.valueOf(",height="))).concat(String.valueOf(this.height))).concat(String.valueOf("]"));
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
        this.info.remove(component);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.getLayoutSize(container, true);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.getLayoutSize(container, false);
    }

    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Rectangle rectangle = this.getComponentBounds(component, true);
            component.setBounds(insets.left + rectangle.x, insets.top + rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void addLayoutComponent(Component component, Object object) {
        if (object instanceof XYConstraints) {
            this.info.put(component, object);
        }
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
    }

    Rectangle getComponentBounds(Component component, boolean bl) {
        XYConstraints xYConstraints = (XYConstraints)this.info.get(component);
        if (xYConstraints == null) {
            xYConstraints = defaultConstraints;
        }
        Rectangle rectangle = new Rectangle(xYConstraints.x, xYConstraints.y, xYConstraints.width, xYConstraints.height);
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            Dimension dimension;
            Dimension dimension2 = dimension = bl ? component.getPreferredSize() : component.getMinimumSize();
            if (rectangle.width <= 0) {
                rectangle.width = dimension.width;
            }
            if (rectangle.height <= 0) {
                rectangle.height = dimension.height;
            }
        }
        return rectangle;
    }

    Dimension getLayoutSize(Container container, boolean bl) {
        Dimension dimension = new Dimension(0, 0);
        if (this.width <= 0 || this.height <= 0) {
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                Rectangle rectangle = this.getComponentBounds(component, bl);
                dimension.width = Math.max(dimension.width, rectangle.x + rectangle.width);
                dimension.height = Math.max(dimension.height, rectangle.y + rectangle.height);
            }
        }
        if (this.width > 0) {
            dimension.width = this.width;
        }
        if (this.height > 0) {
            dimension.height = this.height;
        }
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }
}

