/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.view;

import borland.jbcl.util.ActionMulticaster;
import borland.jbcl.util.ImageLoader;
import borland.jbcl.util.ImageTexture;
import borland.jbcl.util.SerializableImage;
import com.sun.java.swing.JComponent;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class BeanPanel
extends JComponent
implements Serializable {
    private static final long serialVersionUID = 200L;
    protected transient WindowListener winListener = new 1();
    protected transient ActionMulticaster actionMulticaster;
    protected transient Image texture;
    protected boolean focusAware = true;
    protected int focusState;
    protected transient boolean foundParentWindow = false;
    transient Rectangle _bounds = new Rectangle();

    public BeanPanel() {
        this.enableEvents(60L);
        super.setLayout(new FlowLayout());
        super.setDoubleBuffered(true);
        super.setOpaque(true);
    }

    public BeanPanel(LayoutManager layoutManager) {
        this.enableEvents(60L);
        super.setLayout(layoutManager);
        super.setDoubleBuffered(true);
        super.setOpaque(true);
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        if (this.actionMulticaster == null) {
            this.actionMulticaster = new ActionMulticaster();
        }
        this.actionMulticaster.add(actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        if (this.actionMulticaster != null) {
            this.actionMulticaster.remove(actionListener);
        }
    }

    public void setTexture(Image image) {
        this.texture = image;
        if (image != null) {
            ImageLoader.waitForImage(this, image);
        }
        this.repaint();
    }

    public Image getTexture() {
        return this.texture;
    }

    public void setOpaque(boolean bl) {
        super.setOpaque(bl);
        if (this.isVisible()) {
            this.repaint();
        }
    }

    public boolean isOpaque() {
        return this.texture != null ? true : super.isOpaque();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.repaint();
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.isOpaque()) {
            Rectangle rectangle = graphics.getClipBounds();
            if (this.texture != null) {
                ImageTexture.texture(this.texture, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            } else {
                graphics.setColor(this.getBackground());
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)aWTEvent);
        } else {
            super.processEvent(aWTEvent);
        }
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        if (this.actionMulticaster != null) {
            this.actionMulticaster.dispatch(actionEvent);
        }
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (!this.isEnabled()) {
            return;
        }
        super.processKeyEvent(keyEvent);
        if (!keyEvent.isConsumed()) {
            switch (keyEvent.getID()) {
                case 401: {
                    this.processKeyPressed(keyEvent);
                    break;
                }
                case 400: {
                    this.processKeyTyped(keyEvent);
                    break;
                }
                case 402: {
                    this.processKeyReleased(keyEvent);
                }
            }
        }
    }

    protected void processKeyPressed(KeyEvent keyEvent) {
    }

    protected void processKeyTyped(KeyEvent keyEvent) {
    }

    protected void processKeyReleased(KeyEvent keyEvent) {
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        super.processMouseEvent(mouseEvent);
        if (!mouseEvent.isConsumed()) {
            switch (mouseEvent.getID()) {
                case 501: {
                    this.processMousePressed(mouseEvent);
                    break;
                }
                case 502: {
                    this.processMouseReleased(mouseEvent);
                    break;
                }
                case 500: {
                    this.processMouseClicked(mouseEvent);
                    break;
                }
                case 504: {
                    this.processMouseEntered(mouseEvent);
                    break;
                }
                case 505: {
                    this.processMouseExited(mouseEvent);
                }
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        super.processMouseMotionEvent(mouseEvent);
        if (!mouseEvent.isConsumed()) {
            switch (mouseEvent.getID()) {
                case 503: {
                    this.processMouseMoved(mouseEvent);
                    break;
                }
                case 506: {
                    this.processMouseDragged(mouseEvent);
                }
            }
        }
    }

    protected void processMousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 1 && this.isFocusTraversable()) {
            this.requestFocus();
        }
    }

    protected void processMouseReleased(MouseEvent mouseEvent) {
    }

    protected void processMouseClicked(MouseEvent mouseEvent) {
    }

    protected void processMouseEntered(MouseEvent mouseEvent) {
    }

    protected void processMouseExited(MouseEvent mouseEvent) {
    }

    protected void processMouseMoved(MouseEvent mouseEvent) {
    }

    protected void processMouseDragged(MouseEvent mouseEvent) {
    }

    protected void setFocusAware(boolean bl) {
        this.focusAware = bl;
    }

    protected boolean isFocusAware() {
        return this.focusAware;
    }

    public boolean isFocusTraversable() {
        return this.focusAware;
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        if (this.focusAware) {
            switch (focusEvent.getID()) {
                case 1004: {
                    this.focusState |= 2;
                    break;
                }
                case 1005: {
                    this.focusState &= 0xFFFFFFFD;
                }
            }
        }
        super.processFocusEvent(focusEvent);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void windowActiveChanged(boolean bl) {
        this.focusState = bl ? (this.focusState &= 0xFFFFFFDF) : (this.focusState |= 0x20);
    }

    public void addNotify() {
        super.addNotify();
        this.findParentWindow();
    }

    public void removeNotify() {
        this.dropParentWindow();
        super.removeNotify();
    }

    protected void findParentWindow() {
        Container container;
        if (this.foundParentWindow) {
            return;
        }
        for (container = this.getParent(); container != null && !(container instanceof Window); container = container.getParent()) {
        }
        if (container instanceof Window) {
            ((Window)container).addWindowListener(this.winListener);
            this.foundParentWindow = true;
        }
    }

    protected void dropParentWindow() {
        Container container;
        for (container = this.getParent(); container != null && !(container instanceof Window); container = container.getParent()) {
        }
        if (container instanceof Window) {
            ((Window)container).removeWindowListener(this.winListener);
        }
        this.foundParentWindow = false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.texture != null) {
            objectOutputStream.writeObject(SerializableImage.create(this.texture));
        } else {
            objectOutputStream.writeObject(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        Object object = objectInputStream.readObject();
        if (object instanceof SerializableImage) {
            this.texture = ((SerializableImage)object).getImage();
        }
    }

    class 1
    extends WindowAdapter {
        public void windowActivated(WindowEvent windowEvent) {
            BeanPanel.this.windowActiveChanged(true);
        }

        public void windowDeactivated(WindowEvent windowEvent) {
            BeanPanel.this.windowActiveChanged(false);
        }

        1() {
        }
    }
}

