/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.view;

import borland.jbcl.model.BasicSingletonContainer;
import borland.jbcl.model.BasicViewManager;
import borland.jbcl.model.ItemPaintSite;
import borland.jbcl.model.ItemPainter;
import borland.jbcl.model.SingletonModel;
import borland.jbcl.model.SingletonModelEvent;
import borland.jbcl.model.SingletonModelListener;
import borland.jbcl.model.SingletonModelMulticaster;
import borland.jbcl.model.SingletonViewManager;
import borland.jbcl.model.WritableSingletonModel;
import borland.jbcl.view.BeanPanel;
import borland.jbcl.view.FocusableItemPainter;
import borland.jbcl.view.SingletonView;
import borland.jbcl.view.TextItemPainter;
import com.sun.java.swing.BorderFactory;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.border.Border;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;

public class ButtonView
extends BeanPanel
implements SingletonView,
SingletonModelListener,
ItemPaintSite,
Serializable {
    private static final long serialVersionUID = 200L;
    boolean dragOut = false;
    boolean dragging = false;
    private transient SingletonModel model;
    private transient WritableSingletonModel writeModel;
    private transient SingletonViewManager viewManager;
    private boolean readOnly;
    private transient SingletonModelMulticaster modelMulticaster = new SingletonModelMulticaster();
    private boolean showRollover = false;
    protected Insets margins = new Insets(2, 5, 2, 5);
    protected String actionCommand;
    protected int state;
    protected int alignment = 34;
    protected boolean mouseDown;
    protected boolean mouseOver;
    protected Border upBorder = BorderFactory.createRaisedBevelBorder();
    protected Border dnBorder = BorderFactory.createLoweredBevelBorder();

    public ButtonView() {
        super(null);
        super.setBackground(UIManager.getColor("Button.background"));
        super.setForeground(UIManager.getColor("Button.foreground"));
        this.upBorder = BorderFactory.createRaisedBevelBorder();
        this.dnBorder = BorderFactory.createLoweredBevelBorder();
        this.setModel(this.createDefaultModel());
        this.setViewManager(this.createDefaultViewManager());
    }

    public void updateUI() {
        super.updateUI();
        super.setBackground(UIManager.getColor("Button.background"));
        super.setForeground(UIManager.getColor("Button.foreground"));
        this.upBorder = BorderFactory.createRaisedBevelBorder();
        this.dnBorder = BorderFactory.createLoweredBevelBorder();
    }

    protected SingletonModel createDefaultModel() {
        return new BasicSingletonContainer();
    }

    protected SingletonViewManager createDefaultViewManager() {
        return new BasicViewManager(new FocusableItemPainter(new TextItemPainter()));
    }

    public void setItemMargins(Insets insets) {
        this.margins = insets;
    }

    public Insets getItemMargins() {
        return this.margins;
    }

    public boolean isTransparent() {
        return this.texture != null ? true : !this.isOpaque();
    }

    public Component getSiteComponent() {
        return this;
    }

    public String getLabel() {
        Object object = this.model != null ? this.model.get() : null;
        return object != null ? object.toString() : "";
    }

    public void setLabel(String string) {
        if (!this.isReadOnly()) {
            this.writeModel.set(string);
            this.repaint(100L);
        }
    }

    public void setFocusAware(boolean bl) {
        super.setFocusAware(bl);
        this.repaint(100L);
    }

    public boolean isFocusAware() {
        return super.isFocusAware();
    }

    public void setAlignment(int n) {
        this.alignment = n;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setShowRollover(boolean bl) {
        this.showRollover = bl;
        this.repaint(100L);
    }

    public boolean isShowRollover() {
        return this.showRollover;
    }

    public boolean isSelected() {
        return (this.state & 4) != 0;
    }

    public void setSelected(boolean bl) {
        this.state = bl ? (this.state |= 4) : (this.state &= 0xFFFFFFFB);
        this.repaint(100L);
    }

    public void setEnabled(boolean bl) {
        if (this.isEnabled() != bl) {
            if (bl) {
                this.state &= 0xFFFFFFFE;
            } else {
                this.state |= 1;
                this.state &= 0xFFFFFFBF;
                this.state &= 0xFFFFFFFB;
            }
            super.setEnabled(bl);
            this.repaint(100L);
        }
    }

    public void setModel(SingletonModel singletonModel) {
        if (this.model != null) {
            this.model.removeModelListener(this);
            this.model.removeModelListener(this.modelMulticaster);
        }
        this.model = singletonModel;
        if (this.model != null) {
            this.model.addModelListener(this);
            this.model.addModelListener(this.modelMulticaster);
        }
        this.writeModel = this.model instanceof WritableSingletonModel ? (WritableSingletonModel)this.model : null;
        this.repaint(100L);
    }

    public SingletonModel getModel() {
        return this.model;
    }

    public WritableSingletonModel getWriteModel() {
        return this.readOnly ? null : this.writeModel;
    }

    public void addModelListener(SingletonModelListener singletonModelListener) {
        this.modelMulticaster.add(singletonModelListener);
    }

    public void removeModelListener(SingletonModelListener singletonModelListener) {
        this.modelMulticaster.remove(singletonModelListener);
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public boolean isReadOnly() {
        return this.readOnly ? true : this.writeModel == null;
    }

    public SingletonViewManager getViewManager() {
        return this.viewManager;
    }

    public void setViewManager(SingletonViewManager singletonViewManager) {
        this.viewManager = singletonViewManager;
    }

    public void modelContentChanged(SingletonModelEvent singletonModelEvent) {
        this.repaint(100L);
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public Dimension getPreferredSize() {
        Object object;
        Graphics graphics = this.getGraphics();
        Border border = (this.state & 4) != 0 ? this.dnBorder : this.upBorder;
        Insets insets = border.getBorderInsets(this);
        if (this.model != null && this.viewManager != null && (object = this.model.get()) != null) {
            Dimension dimension = this.viewManager.getPainter(object, this.state | this.focusState).getPreferredSize(object, graphics, this.state | this.focusState, this);
            return new Dimension(dimension.width + insets.left + insets.right, dimension.height + insets.top + insets.bottom);
        }
        return new Dimension(insets.left + insets.right + 20, insets.top + insets.bottom + 10);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.repaint(300L);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paintBorder(Graphics graphics) {
        if ((this.state & 4) != 0) {
            this.dnBorder.paintBorder(this, graphics, 0, 0, this.getSize().width, this.getSize().height);
        } else if (!this.showRollover || (this.state & 0x40) != 0) {
            this.upBorder.paintBorder(this, graphics, 0, 0, this.getSize().width, this.getSize().height);
        }
    }

    public void paintComponent(Graphics graphics) {
        ItemPainter itemPainter;
        super.paintComponent(graphics);
        Dimension dimension = this.getSize();
        Insets insets = new Insets(0, 0, 0, 0);
        if ((this.state & 4) != 0) {
            insets = this.dnBorder.getBorderInsets(this);
        } else if (!this.showRollover || (this.state & 0x40) != 0) {
            insets = this.upBorder.getBorderInsets(this);
        }
        Dimension dimension2 = new Dimension(dimension.width - insets.left - insets.right, dimension.height - insets.top - insets.bottom);
        Object object = this.model != null ? this.model.get() : null;
        ItemPainter itemPainter2 = itemPainter = this.viewManager != null ? this.viewManager.getPainter(object, this.state | this.focusState) : null;
        if (itemPainter != null) {
            Rectangle rectangle = new Rectangle(insets.left, insets.top, dimension2.width, dimension2.height);
            Rectangle rectangle2 = graphics.getClipBounds();
            graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor((this.state & 4) != 0 ? UIManager.getColor("Button.pressed") : this.getBackground());
            graphics.setFont(this.getFont());
            itemPainter.paint(object, graphics, rectangle, this.state | this.focusState, this);
            graphics.setClip(rectangle2);
        }
    }

    public void setVisible(boolean bl) {
        if (!bl) {
            this.mouseDown = false;
            this.setSelected(false);
        }
        super.setVisible(bl);
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        if (focusEvent.getID() == 1005) {
            this.state &= 0xFFFFFFFB;
        }
        if (this.focusAware) {
            this.repaint(100L);
        }
    }

    protected void processKeyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 32: {
                this.state |= 4;
                this.repaint();
            }
        }
    }

    protected void processKeyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 32) {
            this.state &= 0xFFFFFFFB;
            this.repaint();
            this.processActionEvent(new ActionEvent(this, 1001, this.getActionCommand()));
        }
    }

    protected void processMousePressed(MouseEvent mouseEvent) {
        super.processMousePressed(mouseEvent);
        if (!mouseEvent.isConsumed()) {
            this.state |= 4;
            this.state &= 0xFFFFFFBF;
            this.mouseDown = true;
            this.mouseOver = true;
            this.repaint();
        }
    }

    protected void processMouseReleased(MouseEvent mouseEvent) {
        super.processMouseReleased(mouseEvent);
        if (!mouseEvent.isConsumed()) {
            this.dragging = false;
            boolean bl = (this.state & 4) != 0;
            this.state &= 0xFFFFFFFB;
            this.mouseDown = false;
            if (this.mouseOver && this.showRollover) {
                this.state |= 0x40;
            }
            this.repaint();
            if (bl) {
                this.processActionEvent(new ActionEvent(this, 1001, this.getActionCommand()));
            }
        }
    }

    protected void processMouseDragged(MouseEvent mouseEvent) {
        super.processMouseDragged(mouseEvent);
        if (!mouseEvent.isConsumed()) {
            this.state &= 0xFFFFFFBF;
            this.dragging = true;
            if (!this.contains(mouseEvent.getX(), mouseEvent.getY())) {
                if (!this.dragOut) {
                    this.dragOut = true;
                    this.mouseOver = false;
                    if (this.mouseDown) {
                        this.state &= 0xFFFFFFFB;
                        this.repaint();
                    }
                }
            } else if (this.dragOut) {
                this.dragOut = false;
                this.mouseOver = true;
                if (this.mouseDown) {
                    this.state |= 4;
                    this.repaint();
                }
            }
        }
    }

    protected void processMouseEntered(MouseEvent mouseEvent) {
        super.processMouseEntered(mouseEvent);
        if (!mouseEvent.isConsumed()) {
            if (this.dragging) {
                return;
            }
            this.mouseOver = true;
            boolean bl = false;
            if (this.mouseDown) {
                this.state |= 4;
                bl = true;
            }
            if (this.showRollover) {
                this.state |= 0x40;
                bl = true;
            }
            if (bl) {
                this.repaint();
            }
        }
    }

    protected void processMouseExited(MouseEvent mouseEvent) {
        super.processMouseExited(mouseEvent);
        if (!mouseEvent.isConsumed()) {
            if (this.dragging) {
                return;
            }
            this.mouseOver = false;
            boolean bl = false;
            if (this.mouseDown) {
                this.state &= 0xFFFFFFFB;
                bl = true;
            }
            if (this.showRollover && !this.mouseDown) {
                this.state &= 0xFFFFFFBF;
                bl = true;
            }
            if (bl) {
                this.repaint();
            }
        }
    }

    protected String paramString() {
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(super.paramString()).concat(String.valueOf(",label="))).concat(String.valueOf(this.getLabel()))).concat(String.valueOf(",state="))).concat(String.valueOf(this.state));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(2);
        if (this.model instanceof Serializable) {
            hashtable.put("m", this.model);
        }
        if (this.viewManager instanceof Serializable) {
            hashtable.put("v", this.viewManager);
        }
        objectOutputStream.writeObject(hashtable);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        Hashtable hashtable = (Hashtable)objectInputStream.readObject();
        Object v = hashtable.get("m");
        if (v instanceof SingletonModel) {
            this.model = (SingletonModel)v;
        }
        if (this.model instanceof WritableSingletonModel) {
            this.writeModel = (WritableSingletonModel)this.model;
        }
        if ((v = hashtable.get("v")) instanceof SingletonViewManager) {
            this.viewManager = (SingletonViewManager)v;
        }
    }
}

