/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.view;

import borland.jbcl.model.ItemPaintSite;
import borland.jbcl.model.ItemPainter;
import borland.jbcl.util.DottedLine;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class FocusableItemPainter
implements ItemPainter,
Serializable {
    private static final long serialVersionUID = 200L;
    protected transient ItemPainter painter;
    protected boolean showRollover = true;
    protected Color rollColor = SystemColor.textHighlight;

    public FocusableItemPainter() {
        this.painter = null;
    }

    public FocusableItemPainter(ItemPainter itemPainter) {
        this.painter = itemPainter;
    }

    public FocusableItemPainter(ItemPainter itemPainter, boolean bl) {
        this.painter = itemPainter;
        this.showRollover = bl;
    }

    public void setPainter(ItemPainter itemPainter) {
        this.painter = itemPainter;
    }

    public ItemPainter getPainter() {
        return this.painter;
    }

    public void setShowRollover(boolean bl) {
        this.showRollover = bl;
    }

    public boolean isShowRollover() {
        return this.showRollover;
    }

    public void setRolloverColor(Color color) {
        this.rollColor = color;
    }

    public Color getRollColor() {
        return this.rollColor;
    }

    public Dimension getPreferredSize(Object object, Graphics graphics, int n, ItemPaintSite itemPaintSite) {
        return this.painter != null ? this.painter.getPreferredSize(object, graphics, n, itemPaintSite) : new Dimension(0, 0);
    }

    public void paint(Object object, Graphics graphics, Rectangle rectangle, int n, ItemPaintSite itemPaintSite) {
        Color color = graphics.getColor();
        if (this.painter != null) {
            this.painter.paint(object, graphics, rectangle, n, itemPaintSite);
        }
        if ((n & 2) != 0) {
            graphics.setColor(Color.black);
            graphics.setXORMode(Color.white);
            DottedLine.drawRect(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setPaintMode();
        } else if (this.showRollover && (n & 0x40) != 0) {
            graphics.setColor(this.rollColor);
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        }
        graphics.setColor(color);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.painter instanceof Serializable ? this.painter : null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        Object object = objectInputStream.readObject();
        if (object instanceof ItemPainter) {
            this.painter = (ItemPainter)object;
        }
    }
}

