/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.view;

import borland.jbcl.model.ItemFormatter;
import borland.jbcl.model.ItemPaintSite;
import borland.jbcl.model.ItemPainter;
import borland.jbcl.util.InvalidFormatException;
import borland.jbcl.util.Variant;
import borland.jbcl.view.Res;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.io.Serializable;

public class TextItemPainter
implements ItemPainter,
Serializable {
    private static final long serialVersionUID = 200L;
    protected int alignment = 33;
    protected Insets margins = new Insets(1, 1, 1, 1);
    protected Color foreground = SystemColor.controlText;
    protected Color background;
    protected boolean paintBackground = true;
    protected ItemFormatter formatter;

    public TextItemPainter() {
    }

    public TextItemPainter(int n) {
        this();
        this.setAlignment(n);
    }

    public TextItemPainter(Insets insets) {
        this();
        this.setMargins(insets);
    }

    public TextItemPainter(ItemFormatter itemFormatter) {
        this();
        this.setFormatter(itemFormatter);
    }

    public TextItemPainter(int n, Insets insets) {
        this();
        this.setAlignment(n);
        this.setMargins(insets);
    }

    public TextItemPainter(int n, Insets insets, ItemFormatter itemFormatter) {
        this();
        this.setAlignment(n);
        this.setMargins(insets);
        this.setFormatter(itemFormatter);
    }

    public void setAlignment(int n) {
        if ((this.alignment & 0xF0) < 0 || (this.alignment & 0xF0) > 48) {
            throw new IllegalArgumentException(Res.format(1, new Integer[]{new Integer(this.alignment & 0xF0)}));
        }
        if ((this.alignment & 0xF) < 0 || (this.alignment & 0xF) > 3) {
            throw new IllegalArgumentException(Res.format(2, new Integer[]{new Integer(this.alignment & 0xF)}));
        }
        this.alignment = n;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setMargins(Insets insets) {
        this.margins = insets;
    }

    public Insets getMargins() {
        return this.margins;
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setPaintBackground(boolean bl) {
        this.paintBackground = bl;
    }

    public boolean isPaintBackground() {
        return this.paintBackground;
    }

    public void setForeground(Color color) {
        this.foreground = color;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setFormatter(ItemFormatter itemFormatter) {
        this.formatter = itemFormatter;
    }

    public ItemFormatter getFormatter() {
        return this.formatter;
    }

    public Dimension getPreferredSize(Object object, Graphics graphics, int n, ItemPaintSite itemPaintSite) {
        Font font;
        if (graphics == null) {
            return new Dimension();
        }
        Font font2 = graphics.getFont();
        Font font3 = font = itemPaintSite != null ? itemPaintSite.getFont() : font2;
        if (font == null) {
            font = font2;
        }
        if (font != null) {
            graphics.setFont(font);
        }
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        String string = this.getText(object);
        Insets insets = itemPaintSite != null ? itemPaintSite.getItemMargins() : this.margins;
        graphics.setFont(font2);
        return new Dimension(insets.left + insets.right + fontMetrics.stringWidth(string), insets.top + insets.bottom + fontMetrics.getHeight());
    }

    public void paint(Object object, Graphics graphics, Rectangle rectangle, int n, ItemPaintSite itemPaintSite) {
        int n2;
        int n3;
        Color color;
        Color color2;
        int n4;
        Insets insets;
        Font font;
        Font font2 = graphics.getFont();
        Color color3 = graphics.getColor();
        Font font3 = font = itemPaintSite != null ? itemPaintSite.getFont() : graphics.getFont();
        if (font == null) {
            font = graphics.getFont();
        }
        graphics.setFont(font);
        Insets insets2 = insets = itemPaintSite != null ? itemPaintSite.getItemMargins() : this.getMargins();
        if (insets == null) {
            insets = this.getMargins();
        }
        int n5 = n4 = itemPaintSite != null ? itemPaintSite.getAlignment() : this.getAlignment();
        if (n4 == 0) {
            n4 = this.getAlignment();
        }
        Color color4 = color2 = itemPaintSite != null ? itemPaintSite.getBackground() : this.getBackground();
        if (color2 == null) {
            color2 = this.getBackground();
        }
        if (color2 == null) {
            color2 = graphics.getColor();
        }
        Color color5 = color = itemPaintSite != null ? itemPaintSite.getForeground() : this.getForeground();
        if (color == null) {
            color = this.getForeground();
        }
        if (color == null) {
            color = SystemColor.windowText;
        }
        boolean bl = itemPaintSite != null ? itemPaintSite.isTransparent() : !this.paintBackground;
        String string = this.getText(object);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        switch (n4 & 0xF) {
            default: {
                n3 = insets.left;
                break;
            }
            case 2: {
                n3 = (rectangle.width - fontMetrics.stringWidth(string)) / 2;
                break;
            }
            case 3: {
                n3 = rectangle.width - fontMetrics.stringWidth(string) - insets.right;
            }
        }
        switch (n4 & 0xF0) {
            default: {
                n2 = insets.top;
                break;
            }
            case 32: {
                n2 = (rectangle.height - fontMetrics.getHeight()) / 2;
                break;
            }
            case 48: {
                n2 = rectangle.height - insets.bottom - fontMetrics.getHeight();
            }
        }
        n2 += fontMetrics.getLeading() + fontMetrics.getAscent();
        if (!bl) {
            graphics.setColor(color2);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        if (string != null) {
            if ((n & 1) != 0) {
                graphics.setColor(SystemColor.controlLtHighlight);
                graphics.drawString(string, rectangle.x + n3 + 1, rectangle.y + n2 + 1);
                graphics.setColor(SystemColor.controlShadow);
            } else {
                graphics.setColor(color);
            }
            graphics.drawString(string, rectangle.x + n3, rectangle.y + n2);
        }
        graphics.setFont(font2);
        graphics.setColor(color3);
    }

    protected String getText(Object object) {
        if (object != null) {
            if (this.formatter != null && object instanceof Variant) {
                try {
                    String string = this.formatter.format(object);
                    return string;
                }
                catch (InvalidFormatException invalidFormatException) {
                    String string = "";
                    return string;
                }
            }
            return object.toString();
        }
        return "";
    }
}

