/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.accessibility.Accessible;
import com.sun.java.accessibility.AccessibleComponent;
import com.sun.java.accessibility.AccessibleContext;
import com.sun.java.accessibility.AccessibleRole;
import com.sun.java.accessibility.AccessibleState;
import com.sun.java.accessibility.AccessibleStateSet;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JLayeredPane;
import com.sun.java.swing.JMenuBar;
import com.sun.java.swing.JRootPane;
import com.sun.java.swing.RootPaneContainer;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.TimerQueue;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.util.Locale;
import java.util.Vector;

public class JApplet
extends Applet
implements Accessible,
RootPaneContainer {
    private static final BorderLayout sharedBorderLayout = new BorderLayout();
    protected JRootPane rootPane;
    protected boolean rootPaneCheckingEnabled = false;
    private boolean hasTimer = false;
    protected AccessibleContext accessibleContext = null;

    public JApplet() {
        this.setLayout(sharedBorderLayout);
        this.setRootPane(this.createRootPane());
        this.setRootPaneCheckingEnabled(true);
    }

    public void addNotify() {
        super.addNotify();
        this.enableEvents(8L);
        if (SwingUtilities.getAncestorOfClass(Class.forName("com.sun.java.swing.RootPaneContainer"), this) == null) {
            this.hasTimer = true;
            TimerQueue.initAppletTimer(this);
        }
        this.setVisible(true);
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.hasTimer) {
            TimerQueue.removeAppletTimer(this);
            this.hasTimer = false;
        }
    }

    protected JRootPane createRootPane() {
        return new JRootPane();
    }

    protected void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
        if (!e.isConsumed()) {
            JComponent.processKeyBindingsForAllComponents(e, this, new Vector(), e.getID() == 401);
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void setJMenuBar(JMenuBar menuBar) {
        this.getRootPane().setMenuBar(menuBar);
    }

    public JMenuBar getJMenuBar() {
        return this.getRootPane().getMenuBar();
    }

    protected boolean isRootPaneCheckingEnabled() {
        return this.rootPaneCheckingEnabled;
    }

    protected void setRootPaneCheckingEnabled(boolean enabled) {
        this.rootPaneCheckingEnabled = enabled;
    }

    private Error createRootPaneException(String op) {
        String type = this.getClass().getName();
        return new Error(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("Do not use ").concat(String.valueOf(type))).concat(String.valueOf("."))).concat(String.valueOf(op))).concat(String.valueOf("() use "))).concat(String.valueOf(type))).concat(String.valueOf(".getContentPane()."))).concat(String.valueOf(op))).concat(String.valueOf("() instead")));
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        if (this.isRootPaneCheckingEnabled()) {
            throw this.createRootPaneException("add");
        }
        super.addImpl(comp, constraints, index);
    }

    public void setLayout(LayoutManager manager) {
        if (this.isRootPaneCheckingEnabled()) {
            throw this.createRootPaneException("setLayout");
        }
        super.setLayout(manager);
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    protected void setRootPane(JRootPane root) {
        if (this.rootPane != null) {
            this.remove(this.rootPane);
        }
        this.rootPane = root;
        if (this.rootPane != null) {
            boolean checkingEnabled = this.isRootPaneCheckingEnabled();
            try {
                this.setRootPaneCheckingEnabled(false);
                this.add((Component)this.rootPane, "Center");
                Object var4_3 = null;
                this.setRootPaneCheckingEnabled(checkingEnabled);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.setRootPaneCheckingEnabled(checkingEnabled);
                throw throwable;
            }
        }
    }

    public Container getContentPane() {
        return this.getRootPane().getContentPane();
    }

    public void setContentPane(Container contentPane) {
        this.getRootPane().setContentPane(contentPane);
    }

    public JLayeredPane getLayeredPane() {
        return this.getRootPane().getLayeredPane();
    }

    public void setLayeredPane(JLayeredPane layeredPane) {
        this.getRootPane().setLayeredPane(layeredPane);
    }

    public Component getGlassPane() {
        return this.getRootPane().getGlassPane();
    }

    public void setGlassPane(Component glassPane) {
        this.getRootPane().setGlassPane(glassPane);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJApplet();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJApplet
    extends AccessibleContext
    implements Serializable,
    AccessibleComponent {
        protected AccessibleJApplet() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.FRAME;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet states = SwingUtilities.getAccessibleStateSet(JApplet.this);
            states.add(AccessibleState.ACTIVE);
            return states;
        }

        public Accessible getAccessibleParent() {
            Container parent = JApplet.this.getParent();
            if (parent instanceof Accessible) {
                return (Accessible)((Object)parent);
            }
            return null;
        }

        public int getAccessibleIndexInParent() {
            return SwingUtilities.getAccessibleIndexInParent(JApplet.this);
        }

        public int getAccessibleChildrenCount() {
            return SwingUtilities.getAccessibleChildrenCount(JApplet.this);
        }

        public Accessible getAccessibleChild(int i) {
            return SwingUtilities.getAccessibleChild(JApplet.this, i);
        }

        public Locale getLocale() {
            return JApplet.this.getLocale();
        }

        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        public Color getBackground() {
            return JApplet.this.getBackground();
        }

        public void setBackground(Color c) {
            JApplet.this.setBackground(c);
        }

        public Color getForeground() {
            return JApplet.this.getForeground();
        }

        public void setForeground(Color c) {
            JApplet.this.setForeground(c);
        }

        public Cursor getCursor() {
            return JApplet.this.getCursor();
        }

        public void setCursor(Cursor cursor) {
            JApplet.this.setCursor(cursor);
        }

        public Font getFont() {
            return JApplet.this.getFont();
        }

        public void setFont(Font f) {
            ((Component)JApplet.this).setFont(f);
        }

        public FontMetrics getFontMetrics(Font f) {
            return JApplet.this.getFontMetrics(f);
        }

        public boolean isEnabled() {
            return JApplet.this.isEnabled();
        }

        public void setEnabled(boolean b) {
            JApplet.this.setEnabled(b);
        }

        public boolean isVisible() {
            return JApplet.this.isVisible();
        }

        public void setVisible(boolean b) {
            JApplet.this.setVisible(b);
        }

        public boolean isShowing() {
            return JApplet.this.isShowing();
        }

        public boolean contains(Point p) {
            return JApplet.this.contains(p);
        }

        public Point getLocationOnScreen() {
            return JApplet.this.getLocationOnScreen();
        }

        public Point getLocation() {
            return JApplet.this.getLocation();
        }

        public void setLocation(Point p) {
            JApplet.this.setLocation(p);
        }

        public Rectangle getBounds() {
            return JApplet.this.getBounds();
        }

        public void setBounds(Rectangle r) {
            JApplet.this.setBounds(r);
        }

        public Dimension getSize() {
            return JApplet.this.getSize();
        }

        public void setSize(Dimension d) {
            JApplet.this.setSize(d);
        }

        public Accessible getAccessibleAt(Point p) {
            return SwingUtilities.getAccessibleAt(JApplet.this, p);
        }

        public boolean isFocusTraversable() {
            return JApplet.this.isFocusTraversable();
        }

        public void requestFocus() {
            JApplet.this.requestFocus();
        }

        public void addFocusListener(FocusListener l) {
            JApplet.this.addFocusListener(l);
        }

        public void removeFocusListener(FocusListener l) {
            JApplet.this.removeFocusListener(l);
        }
    }
}

