/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.border;

import com.sun.java.swing.Icon;
import com.sun.java.swing.border.EmptyBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;

public class MatteBorder
extends EmptyBorder {
    protected Color color;
    protected Icon tileIcon;

    public MatteBorder(int n, int n2, int n3, int n4, Color color) {
        super(n, n2, n3, n4);
        this.color = color;
    }

    public MatteBorder(int n, int n2, int n3, int n4, Icon icon) {
        super(n, n2, n3, n4);
        this.tileIcon = icon;
    }

    public MatteBorder(Icon icon) {
        this(-1, -1, -1, -1, icon);
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Insets insets = this.getBorderInsets(component);
        Color color = graphics.getColor();
        graphics.translate(n, n2);
        if (this.color != null) {
            graphics.setColor(this.color);
            graphics.fillRect(0, 0, n3 - insets.right, insets.top);
            graphics.fillRect(0, insets.top, insets.left, n4 - insets.top);
            graphics.fillRect(insets.left, n4 - insets.bottom, n3 - insets.left, insets.bottom);
            graphics.fillRect(n3 - insets.right, 0, insets.right, n4 - insets.bottom);
        } else if (this.tileIcon != null) {
            int n5;
            int n6 = this.tileIcon.getIconWidth();
            int n7 = this.tileIcon.getIconHeight();
            Graphics graphics2 = graphics.create();
            graphics2.setClip(0, 0, n3, insets.top);
            int n8 = 0;
            while (insets.top - n8 > 0) {
                n5 = 0;
                while (n3 - n5 > 0) {
                    this.tileIcon.paintIcon(component, graphics2, n5, n8);
                    n5 += n6;
                }
                n8 += n7;
            }
            graphics2.dispose();
            graphics2 = graphics.create();
            graphics2.setClip(0, insets.top, insets.left, n4 - insets.top);
            int n9 = insets.top - insets.top % n7;
            int n10 = 0;
            n8 = n9;
            while (n4 - n8 > 0) {
                n5 = n10;
                while (insets.left - n5 > 0) {
                    this.tileIcon.paintIcon(component, graphics2, n5, n8);
                    n5 += n6;
                }
                n8 += n7;
            }
            graphics2.dispose();
            graphics2 = graphics.create();
            graphics2.setClip(insets.left, n4 - insets.bottom, n3 - insets.left, insets.bottom);
            n9 = n4 - insets.bottom - (n4 - insets.bottom) % n7;
            n10 = insets.left - insets.left % n6;
            n8 = n9;
            while (n4 - n8 > 0) {
                n5 = n10;
                while (n3 - n5 > 0) {
                    this.tileIcon.paintIcon(component, graphics2, n5, n8);
                    n5 += n6;
                }
                n8 += n7;
            }
            graphics2.dispose();
            graphics2 = graphics.create();
            graphics2.setClip(n3 - insets.right, insets.top, insets.right, n4 - insets.top - insets.bottom);
            n9 = insets.top - insets.top % n7;
            n10 = n3 - insets.right - (n3 - insets.right) % n6;
            n8 = n9;
            while (n4 - n8 > 0) {
                n5 = n10;
                while (n3 - n5 > 0) {
                    this.tileIcon.paintIcon(component, graphics2, n5, n8);
                    n5 += n6;
                }
                n8 += n7;
            }
            graphics2.dispose();
        }
        graphics.translate(-n, -n2);
        graphics.setColor(color);
    }

    public Insets getBorderInsets(Component component) {
        if (this.tileIcon != null && this.top == -1 && this.bottom == -1 && this.left == -1 && this.right == -1) {
            int n = this.tileIcon.getIconWidth();
            int n2 = this.tileIcon.getIconHeight();
            return new Insets(n2, n, n2, n);
        }
        return new Insets(this.top, this.left, this.bottom, this.right);
    }

    public boolean isBorderOpaque() {
        return this.color != null;
    }
}

