/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.BoundedRangeModel;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JScrollBar;
import com.sun.java.swing.LookAndFeel;
import com.sun.java.swing.SwingConstants;
import com.sun.java.swing.Timer;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.event.ChangeEvent;
import com.sun.java.swing.event.ChangeListener;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.ScrollBarUI;
import com.sun.java.swing.plaf.basic.BasicArrowButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;

public class BasicScrollBarUI
extends ScrollBarUI
implements LayoutManager,
Serializable,
SwingConstants {
    private static final Dimension minimumThumbSize = new Dimension(8, 8);
    private static final Dimension maximumThumbSize = new Dimension(4096, 4096);
    private static Color thumbHighlightColor;
    private static Color thumbLightShadowColor;
    private static Color thumbDarkShadowColor;
    private static Color thumbColor;
    private static Color trackColor;
    private static Color trackHighlightColor;
    private static boolean scrollBarColorsInitialized;
    protected JScrollBar scrollbar;
    protected JButton incrButton;
    protected JButton decrButton;
    protected boolean isDragging;
    protected TrackListener trackListener;
    protected ArrowButtonListener buttonListener;
    protected ModelListener modelListener;
    private Rectangle thumbRect;
    private Rectangle trackRect;
    protected int trackHighlight;
    protected static final int NO_HIGHLIGHT = 0;
    protected static final int DECREASE_HIGHLIGHT = 1;
    protected static final int INCREASE_HIGHLIGHT = 2;
    protected ScrollListener scrollListener;
    protected Timer scrollTimer;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicScrollBarUI();
    }

    protected void configureScrollBarColors() {
        if (!scrollBarColorsInitialized) {
            thumbHighlightColor = UIManager.getColor("ScrollBar.thumbHighlight");
            thumbLightShadowColor = UIManager.getColor("ScrollBar.thumbLightShadow");
            thumbDarkShadowColor = UIManager.getColor("ScrollBar.thumbDarkShadow");
            thumbColor = UIManager.getColor("ScrollBar.thumb");
            trackColor = UIManager.getColor("ScrollBar.track");
            trackHighlightColor = UIManager.getColor("ScrollBar.trackHighlight");
            scrollBarColorsInitialized = true;
        }
    }

    public void installUI(JComponent jComponent) {
        this.scrollbar = (JScrollBar)jComponent;
        this.thumbRect = new Rectangle(0, 0, 0, 0);
        this.trackRect = new Rectangle(0, 0, 0, 0);
        this.trackHighlight = 0;
        switch (((JScrollBar)jComponent).getOrientation()) {
            case 1: {
                this.incrButton = this.createIncreaseButton(5);
                this.decrButton = this.createDecreaseButton(1);
                break;
            }
            case 0: {
                this.incrButton = this.createIncreaseButton(3);
                this.decrButton = this.createDecreaseButton(7);
                break;
            }
        }
        this.scrollbar.setLayout(this);
        this.scrollbar.add(this.incrButton);
        this.scrollbar.add(this.decrButton);
        this.trackListener = new TrackListener();
        this.buttonListener = new ArrowButtonListener();
        this.modelListener = new ModelListener();
        this.scrollbar.addMouseListener(this.trackListener);
        this.scrollbar.addMouseMotionListener(this.trackListener);
        this.scrollbar.getModel().addChangeListener(this.modelListener);
        if (this.incrButton != null) {
            this.incrButton.addMouseListener(this.buttonListener);
        }
        if (this.decrButton != null) {
            this.decrButton.addMouseListener(this.buttonListener);
        }
        this.scrollbar.setEnabled(this.scrollbar.isEnabled());
        this.scrollbar.setOpaque(true);
        this.scrollListener = new ScrollListener();
        this.scrollTimer = new Timer(100, this.scrollListener);
        this.scrollTimer.setInitialDelay(300);
        LookAndFeel.installBorder(this.scrollbar, "ScrollBar.border");
        this.configureScrollBarColors();
    }

    public void uninstallUI(JComponent jComponent) {
        this.scrollTimer.stop();
        this.scrollTimer = null;
        if (this.decrButton != null) {
            this.decrButton.removeMouseListener(this.buttonListener);
        }
        if (this.incrButton != null) {
            this.incrButton.removeMouseListener(this.buttonListener);
        }
        this.scrollbar.getModel().removeChangeListener(this.modelListener);
        this.scrollbar.removeMouseListener(this.trackListener);
        this.scrollbar.removeMouseMotionListener(this.trackListener);
        this.scrollbar.remove(this.incrButton);
        this.scrollbar.remove(this.decrButton);
        this.scrollbar.setLayout(null);
        this.thumbRect = null;
        this.incrButton = null;
        this.decrButton = null;
        this.scrollbar = null;
    }

    protected void paintBackground(Graphics graphics, JComponent jComponent) {
        graphics.setColor(jComponent.getBackground());
        graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        this.paintBackground(graphics, jComponent);
        this.paintTrack(graphics, jComponent, this.getTrackBounds());
        this.paintThumb(graphics, jComponent, this.getThumbBounds());
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        if (this.scrollbar.getOrientation() == 1) {
            return new Dimension(16, 48);
        }
        return new Dimension(48, 16);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    protected JButton createDecreaseButton(int n) {
        return new BasicArrowButton(n);
    }

    protected JButton createIncreaseButton(int n) {
        return new BasicArrowButton(n);
    }

    protected void paintDecreaseHighlight(Graphics graphics) {
        Insets insets = this.scrollbar.getInsets();
        Rectangle rectangle = this.getThumbBounds();
        graphics.setColor(trackHighlightColor);
        if (this.scrollbar.getOrientation() == 1) {
            int n = insets.left;
            int n2 = this.decrButton.getY() + this.decrButton.getHeight();
            int n3 = this.scrollbar.getWidth() - (insets.left + insets.right);
            int n4 = rectangle.y - n2;
            graphics.fillRect(n, n2, n3, n4);
            return;
        }
        int n = this.decrButton.getX() + this.decrButton.getHeight();
        int n5 = insets.top;
        int n6 = rectangle.x - n;
        int n7 = this.scrollbar.getHeight() - (insets.top + insets.bottom);
        graphics.fillRect(n, n5, n6, n7);
    }

    protected void paintIncreaseHighlight(Graphics graphics) {
        Insets insets = this.scrollbar.getInsets();
        Rectangle rectangle = this.getThumbBounds();
        graphics.setColor(trackHighlightColor);
        if (this.scrollbar.getOrientation() == 1) {
            int n = insets.left;
            int n2 = rectangle.y + rectangle.height;
            int n3 = this.scrollbar.getWidth() - (insets.left + insets.right);
            int n4 = this.incrButton.getY() - n2;
            graphics.fillRect(n, n2, n3, n4);
            return;
        }
        int n = rectangle.x + rectangle.width;
        int n5 = insets.top;
        int n6 = this.incrButton.getX() - n;
        int n7 = this.scrollbar.getHeight() - (insets.top + insets.bottom);
        graphics.fillRect(n, n5, n6, n7);
    }

    protected void paintTrack(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        graphics.setColor(trackColor);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (this.trackHighlight == 1) {
            this.paintDecreaseHighlight(graphics);
            return;
        }
        if (this.trackHighlight == 2) {
            this.paintIncreaseHighlight(graphics);
        }
    }

    protected void paintThumb(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        if (rectangle.isEmpty() || !this.scrollbar.isEnabled()) {
            return;
        }
        int n = rectangle.width;
        int n2 = rectangle.height;
        graphics.translate(rectangle.x, rectangle.y);
        graphics.setColor(thumbDarkShadowColor);
        graphics.drawRect(0, 0, n - 1, n2 - 1);
        graphics.setColor(thumbColor);
        graphics.fillRect(0, 0, n - 1, n2 - 1);
        graphics.setColor(thumbHighlightColor);
        graphics.drawLine(1, 1, 1, n2 - 2);
        graphics.drawLine(2, 1, n - 3, 1);
        graphics.setColor(thumbLightShadowColor);
        graphics.drawLine(2, n2 - 2, n - 2, n2 - 2);
        graphics.drawLine(n - 2, 1, n - 2, n2 - 3);
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    protected Dimension getMinimumThumbSize() {
        return minimumThumbSize;
    }

    protected Dimension getMaximumThumbSize() {
        return maximumThumbSize;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.getPreferredSize((JComponent)container);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.getMinimumSize((JComponent)container);
    }

    protected void layoutVScrollbar(JScrollBar jScrollBar) {
        int n;
        Dimension dimension = jScrollBar.getSize();
        Insets insets = jScrollBar.getInsets();
        int n2 = dimension.width - (insets.left + insets.right);
        int n3 = insets.left;
        int n4 = this.decrButton.getPreferredSize().height;
        int n5 = insets.top;
        int n6 = this.incrButton.getPreferredSize().height;
        int n7 = dimension.height - (insets.bottom + n6);
        int n8 = insets.top + insets.bottom;
        int n9 = n4 + n6;
        float f = dimension.height - (n8 + n9);
        float f2 = jScrollBar.getMinimum();
        float f3 = jScrollBar.getVisibleAmount();
        float f4 = jScrollBar.getValue();
        float f5 = (float)jScrollBar.getMaximum() - f2;
        int n10 = (int)(f * (f3 / f5));
        n10 = Math.max(n10, this.getMinimumThumbSize().height);
        n10 = Math.min(n10, this.getMaximumThumbSize().height);
        int n11 = n7 - n10;
        if (jScrollBar.getValue() < jScrollBar.getMaximum() - jScrollBar.getVisibleAmount()) {
            float f6 = f - (float)n10;
            n11 = (int)(0.5f + f6 * ((f4 - f2) / (f5 - f3)));
            n11 += n5 + n4;
        }
        if ((n = dimension.height - n8) < n9) {
            n6 = n4 = n / 2;
            n7 = dimension.height - (insets.bottom + n6);
        }
        this.decrButton.setBounds(n3, n5, n2, n4);
        this.incrButton.setBounds(n3, n7, n2, n6);
        int n12 = n5 + n4;
        int n13 = n7 - n12;
        this.trackRect.setBounds(n3, n12, n2, n13);
        if (n10 >= (int)f) {
            this.setThumbBounds(0, 0, 0, 0);
            return;
        }
        if (n11 + n10 > n7) {
            n11 = n7 - n10;
        }
        if (n11 < n5 + n4) {
            n11 = n5 + n4 + 1;
        }
        this.setThumbBounds(n3, n11, n2, n10);
    }

    protected void layoutHScrollbar(JScrollBar jScrollBar) {
        int n;
        Dimension dimension = jScrollBar.getSize();
        Insets insets = jScrollBar.getInsets();
        int n2 = dimension.height - (insets.top + insets.bottom);
        int n3 = insets.top;
        int n4 = this.decrButton.getPreferredSize().width;
        int n5 = insets.left;
        int n6 = this.incrButton.getPreferredSize().width;
        int n7 = dimension.width - (insets.right + n6);
        int n8 = insets.left + insets.right;
        int n9 = n4 + n6;
        float f = dimension.width - (n8 + n9);
        float f2 = jScrollBar.getMinimum();
        float f3 = jScrollBar.getVisibleAmount();
        float f4 = (float)jScrollBar.getMaximum() - f2;
        float f5 = jScrollBar.getValue();
        int n10 = (int)(f * (f3 / f4));
        n10 = Math.max(n10, this.getMinimumThumbSize().width);
        n10 = Math.min(n10, this.getMaximumThumbSize().width);
        int n11 = n7 - n10;
        if (jScrollBar.getValue() < jScrollBar.getMaximum() - jScrollBar.getVisibleAmount()) {
            float f6 = f - (float)n10;
            n11 = (int)(0.5f + f6 * ((f5 - f2) / (f4 - f3)));
            n11 += n5 + n4;
        }
        if ((n = dimension.width - n8) < n9) {
            n6 = n4 = n / 2;
            n7 = dimension.width - (insets.right + n6);
        }
        this.decrButton.setBounds(n5, n3, n4, n2);
        this.incrButton.setBounds(n7, n3, n6, n2);
        int n12 = n5 + n4;
        int n13 = n7 - n12;
        this.trackRect.setBounds(n12, n3, n13, n2);
        if (n10 >= (int)f) {
            this.setThumbBounds(0, 0, 0, 0);
            return;
        }
        if (n11 + n10 > n7) {
            n11 = n7 - n10;
        }
        if (n11 < n5 + n4) {
            n11 = n5 + n4 + 1;
        }
        this.setThumbBounds(n11, n3, n10, n2);
    }

    public void layoutContainer(Container container) {
        if (this.isDragging) {
            return;
        }
        JScrollBar jScrollBar = (JScrollBar)container;
        switch (jScrollBar.getOrientation()) {
            case 1: {
                this.layoutVScrollbar(jScrollBar);
                return;
            }
            case 0: {
                this.layoutHScrollbar(jScrollBar);
                return;
            }
        }
    }

    protected void setThumbBounds(int n, int n2, int n3, int n4) {
        if (this.thumbRect.x == n && this.thumbRect.y == n2 && this.thumbRect.width == n3 && this.thumbRect.height == n4) {
            return;
        }
        int n5 = Math.min(n, this.thumbRect.x);
        int n6 = Math.min(n2, this.thumbRect.y);
        int n7 = Math.max(n + n3, this.thumbRect.x + this.thumbRect.width);
        int n8 = Math.max(n2 + n4, this.thumbRect.y + this.thumbRect.height);
        this.thumbRect.setBounds(n, n2, n3, n4);
        this.scrollbar.repaint(n5, n6, n7 - n5, n8 - n6);
    }

    protected Rectangle getThumbBounds() {
        return this.thumbRect;
    }

    protected Rectangle getTrackBounds() {
        return this.trackRect;
    }

    protected void scrollByBlock(int n) {
        JScrollBar jScrollBar = this.scrollbar;
        synchronized (jScrollBar) {
            int n2 = this.scrollbar.getValue();
            int n3 = this.scrollbar.getBlockIncrement(n);
            int n4 = n3 * (n > 0 ? 1 : -1);
            this.scrollbar.setValue(n2 + n4);
            this.trackHighlight = n > 0 ? 2 : 1;
            Rectangle rectangle = this.getTrackBounds();
            this.scrollbar.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            return;
        }
    }

    protected void scrollByUnit(int n) {
        JScrollBar jScrollBar = this.scrollbar;
        synchronized (jScrollBar) {
            int n2 = n > 0 ? this.scrollbar.getUnitIncrement(n) : -this.scrollbar.getUnitIncrement(n);
            this.scrollbar.setValue(n2 + this.scrollbar.getValue());
            return;
        }
    }

    protected class ModelListener
    implements ChangeListener,
    Serializable {
        public void stateChanged(ChangeEvent changeEvent) {
            BasicScrollBarUI.this.layoutContainer(BasicScrollBarUI.this.scrollbar);
        }

        ModelListener() {
            BasicScrollBarUI.this = BasicScrollBarUI.this;
        }
    }

    protected class TrackListener
    extends MouseAdapter
    implements MouseMotionListener,
    Serializable {
        protected transient int offset;
        protected transient int currentMouseX;
        protected transient int currentMouseY;

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!BasicScrollBarUI.this.scrollbar.isEnabled()) {
                return;
            }
            if (BasicScrollBarUI.this.trackHighlight != 0) {
                Rectangle rectangle = BasicScrollBarUI.this.getTrackBounds();
                BasicScrollBarUI.this.scrollbar.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            BasicScrollBarUI.this.trackHighlight = 0;
            BasicScrollBarUI.this.isDragging = false;
            this.offset = 0;
            BasicScrollBarUI.this.scrollTimer.stop();
            BasicScrollBarUI.this.scrollbar.setValueIsAdjusting(false);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!BasicScrollBarUI.this.scrollbar.isEnabled()) {
                return;
            }
            BasicScrollBarUI.this.scrollbar.setValueIsAdjusting(true);
            this.currentMouseX = mouseEvent.getX();
            this.currentMouseY = mouseEvent.getY();
            if (BasicScrollBarUI.this.getThumbBounds().contains(this.currentMouseX, this.currentMouseY)) {
                switch (BasicScrollBarUI.this.scrollbar.getOrientation()) {
                    case 1: {
                        this.offset = this.currentMouseY - BasicScrollBarUI.this.getThumbBounds().y;
                        break;
                    }
                    case 0: {
                        this.offset = this.currentMouseX - BasicScrollBarUI.this.getThumbBounds().x;
                        break;
                    }
                }
                BasicScrollBarUI.this.isDragging = true;
                return;
            }
            BasicScrollBarUI.this.isDragging = false;
            Dimension dimension = BasicScrollBarUI.this.scrollbar.getSize();
            int n = 1;
            switch (BasicScrollBarUI.this.scrollbar.getOrientation()) {
                case 1: {
                    if (BasicScrollBarUI.this.getThumbBounds().isEmpty()) {
                        int n2 = dimension.height / 2;
                        n = this.currentMouseY < n2 ? -1 : 1;
                        break;
                    }
                    int n3 = BasicScrollBarUI.this.getThumbBounds().y;
                    n = this.currentMouseY < n3 ? -1 : 1;
                    break;
                }
                case 0: {
                    if (BasicScrollBarUI.this.getThumbBounds().isEmpty()) {
                        int n4 = dimension.width / 2;
                        n = this.currentMouseX < n4 ? -1 : 1;
                        break;
                    }
                    int n5 = BasicScrollBarUI.this.getThumbBounds().x;
                    n = this.currentMouseX < n5 ? -1 : 1;
                    break;
                }
            }
            BasicScrollBarUI.this.scrollByBlock(n);
            if (!BasicScrollBarUI.this.getThumbBounds().contains(this.currentMouseX, this.currentMouseY)) {
                BasicScrollBarUI.this.scrollTimer.stop();
                BasicScrollBarUI.this.scrollListener.setDirection(n);
                BasicScrollBarUI.this.scrollListener.setScrollByBlock(true);
                BasicScrollBarUI.this.scrollTimer.start();
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n;
            int n2;
            int n3;
            if (!BasicScrollBarUI.this.scrollbar.isEnabled() || !BasicScrollBarUI.this.isDragging) {
                return;
            }
            BoundedRangeModel boundedRangeModel = BasicScrollBarUI.this.scrollbar.getModel();
            Rectangle rectangle = BasicScrollBarUI.this.getThumbBounds();
            if (BasicScrollBarUI.this.scrollbar.getOrientation() == 1) {
                n3 = BasicScrollBarUI.this.decrButton.getY() + BasicScrollBarUI.this.decrButton.getHeight();
                n2 = BasicScrollBarUI.this.incrButton.getY() - BasicScrollBarUI.this.getThumbBounds().height;
                n = Math.min(n2, Math.max(n3, mouseEvent.getY() - this.offset));
                BasicScrollBarUI.this.setThumbBounds(rectangle.x, n, rectangle.width, rectangle.height);
                float f = BasicScrollBarUI.this.getTrackBounds().height;
            } else {
                n3 = BasicScrollBarUI.this.decrButton.getX() + BasicScrollBarUI.this.decrButton.getWidth();
                n2 = BasicScrollBarUI.this.incrButton.getX() - BasicScrollBarUI.this.getThumbBounds().width;
                n = Math.min(n2, Math.max(n3, mouseEvent.getX() - this.offset));
                BasicScrollBarUI.this.setThumbBounds(n, rectangle.y, rectangle.width, rectangle.height);
                float f = BasicScrollBarUI.this.getTrackBounds().width;
            }
            if (n == n2) {
                BasicScrollBarUI.this.scrollbar.setValue(boundedRangeModel.getMaximum() - boundedRangeModel.getExtent());
                return;
            }
            float f = boundedRangeModel.getMaximum() - boundedRangeModel.getExtent();
            float f2 = f - (float)boundedRangeModel.getMinimum();
            float f3 = n - n3;
            float f4 = n2 - n3;
            int n4 = (int)(0.5 + (double)(f3 / f4 * f2));
            BasicScrollBarUI.this.scrollbar.setValue(n4 + boundedRangeModel.getMinimum());
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        TrackListener() {
            BasicScrollBarUI.this = BasicScrollBarUI.this;
        }
    }

    protected class ArrowButtonListener
    extends MouseAdapter
    implements Serializable {
        boolean handledEvent;

        public void mousePressed(MouseEvent mouseEvent) {
            if (!BasicScrollBarUI.this.scrollbar.isEnabled()) {
                return;
            }
            int n = mouseEvent.getSource() == BasicScrollBarUI.this.incrButton ? 1 : -1;
            BasicScrollBarUI.this.scrollByUnit(n);
            BasicScrollBarUI.this.scrollTimer.stop();
            BasicScrollBarUI.this.scrollListener.setDirection(n);
            BasicScrollBarUI.this.scrollListener.setScrollByBlock(false);
            BasicScrollBarUI.this.scrollTimer.start();
            this.handledEvent = true;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            BasicScrollBarUI.this.scrollTimer.stop();
            this.handledEvent = false;
            BasicScrollBarUI.this.scrollbar.setValueIsAdjusting(false);
        }

        ArrowButtonListener() {
            BasicScrollBarUI.this = BasicScrollBarUI.this;
        }
    }

    protected class ScrollListener
    implements ActionListener,
    Serializable {
        int direction = 1;
        boolean useBlockIncrement;

        public ScrollListener() {
            BasicScrollBarUI.this = BasicScrollBarUI.this;
            this.direction = 1;
            this.useBlockIncrement = false;
        }

        public ScrollListener(int n, boolean bl) {
            BasicScrollBarUI.this = BasicScrollBarUI.this;
            this.direction = n;
            this.useBlockIncrement = bl;
        }

        public void setDirection(int n) {
            this.direction = n;
        }

        public void setScrollByBlock(boolean bl) {
            this.useBlockIncrement = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.useBlockIncrement) {
                BasicScrollBarUI.this.scrollByBlock(this.direction);
                if (BasicScrollBarUI.this.scrollbar.getOrientation() == 1) {
                    if (this.direction > 0) {
                        if (BasicScrollBarUI.this.getThumbBounds().y + BasicScrollBarUI.this.getThumbBounds().height >= BasicScrollBarUI.this.trackListener.currentMouseY) {
                            ((Timer)actionEvent.getSource()).stop();
                        }
                    } else if (BasicScrollBarUI.this.getThumbBounds().y <= BasicScrollBarUI.this.trackListener.currentMouseY) {
                        ((Timer)actionEvent.getSource()).stop();
                    }
                } else if (this.direction > 0) {
                    if (BasicScrollBarUI.this.getThumbBounds().x + BasicScrollBarUI.this.getThumbBounds().width >= BasicScrollBarUI.this.trackListener.currentMouseX) {
                        ((Timer)actionEvent.getSource()).stop();
                    }
                } else if (BasicScrollBarUI.this.getThumbBounds().x <= BasicScrollBarUI.this.trackListener.currentMouseX) {
                    ((Timer)actionEvent.getSource()).stop();
                }
            } else {
                BasicScrollBarUI.this.scrollByUnit(this.direction);
            }
            if (this.direction > 0 && BasicScrollBarUI.this.scrollbar.getValue() + BasicScrollBarUI.this.scrollbar.getVisibleAmount() >= BasicScrollBarUI.this.scrollbar.getMaximum()) {
                ((Timer)actionEvent.getSource()).stop();
                return;
            }
            if (this.direction < 0 && BasicScrollBarUI.this.scrollbar.getValue() <= BasicScrollBarUI.this.scrollbar.getMinimum()) {
                ((Timer)actionEvent.getSource()).stop();
            }
        }
    }
}

