/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.Icon;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JTree;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.tree.TreeCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;

public class BasicTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    protected boolean selected;
    protected transient Icon closedIcon;
    protected transient Icon leafIcon;
    protected transient Icon openIcon;
    protected Color textSelectionColor;
    protected Color textNonSelectionColor;
    protected Color backgroundSelectionColor;
    protected Color backgroundNonSelectionColor;
    protected Color borderSelectionColor;

    public BasicTreeCellRenderer() {
        this.setHorizontalAlignment(2);
        this.setLeafIcon(UIManager.getIcon("Tree.leafIcon"));
        this.setClosedIcon(UIManager.getIcon("Tree.closedIcon"));
        this.setOpenIcon(UIManager.getIcon("Tree.openIcon"));
        this.setTextSelectionColor(UIManager.getColor("Tree.textSelectionColor"));
        this.setTextNonSelectionColor(UIManager.getColor("Tree.textNonSelectionColor"));
        this.setBackgroundSelectionColor(UIManager.getColor("Tree.backgroundSelectionColor"));
        this.setBackgroundNonSelectionColor(UIManager.getColor("Tree.backgroundNonSelectionColor"));
        this.setBorderSelectionColor(UIManager.getColor("Tree.borderSelectionColor"));
    }

    public Icon getDefaultOpenIcon() {
        return this.openIcon;
    }

    public Icon getDefaultClosedIcon() {
        return this.closedIcon;
    }

    public Icon getDefaultLeafIcon() {
        return this.leafIcon;
    }

    public void setOpenIcon(Icon icon) {
        this.openIcon = icon;
    }

    public Icon getOpenIcon() {
        return this.openIcon;
    }

    public void setClosedIcon(Icon icon) {
        this.closedIcon = icon;
    }

    public Icon getClosedIcon() {
        return this.closedIcon;
    }

    public void setLeafIcon(Icon icon) {
        this.leafIcon = icon;
    }

    public Icon getLeafIcon() {
        return this.leafIcon;
    }

    public void setTextSelectionColor(Color color) {
        this.textSelectionColor = color;
    }

    public Color getTextSelectionColor() {
        return this.textSelectionColor;
    }

    public void setTextNonSelectionColor(Color color) {
        this.textNonSelectionColor = color;
    }

    public Color getTextNonSelectionColor() {
        return this.textNonSelectionColor;
    }

    public void setBackgroundSelectionColor(Color color) {
        this.backgroundSelectionColor = color;
    }

    public Color getBackgroundSelectionColor() {
        return this.backgroundSelectionColor;
    }

    public void setBackgroundNonSelectionColor(Color color) {
        this.backgroundNonSelectionColor = color;
    }

    public Color getBackgroundNonSelectionColor() {
        return this.backgroundNonSelectionColor;
    }

    public void setBorderSelectionColor(Color color) {
        this.borderSelectionColor = color;
    }

    public Color getBorderSelectionColor() {
        return this.borderSelectionColor;
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        String string = jTree.convertValueToText(object, bl, bl2, bl3, n, bl4);
        this.setText(string);
        if (bl) {
            this.setForeground(this.getTextSelectionColor());
        } else {
            this.setForeground(this.getTextNonSelectionColor());
        }
        if (bl3) {
            this.setIcon(this.getLeafIcon());
        } else if (bl2) {
            this.setIcon(this.getOpenIcon());
        } else {
            this.setIcon(this.getClosedIcon());
        }
        this.selected = bl;
        return this;
    }

    public void paint(Graphics graphics) {
        Color color;
        if (this.selected) {
            color = this.getBackgroundSelectionColor();
        } else {
            color = this.getBackgroundNonSelectionColor();
            if (color == null) {
                color = this.getBackground();
            }
        }
        if (color != null) {
            Icon icon = this.getIcon();
            graphics.setColor(color);
            if (icon != null && this.getText() != null) {
                int n = icon.getIconWidth() + this.getIconTextGap();
                graphics.fillRect(n, 0, this.getWidth() - 1 - n, this.getHeight() - 1);
            } else {
                graphics.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
        }
        if (this.selected) {
            graphics.setColor(this.getBorderSelectionColor());
            graphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
        super.paint(graphics);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension != null) {
            dimension = new Dimension(dimension.width + 3, dimension.height);
        }
        return dimension;
    }
}

