/*
 * Decompiled with CFR 0.152.
 */
package edu;

import edu.FlagCreator;
import edu.MoveControl;
import edu.Robot;
import java.awt.Graphics;

public class FlagManager {
    int flagCnt;
    final int MAX_FLAG = 6;
    boolean[] flagTransferring = new boolean[6];
    byte[][] flagMap = new byte[410][265];
    FlagCreator[] flag = new FlagCreator[6];
    Robot robot;
    MoveControl mc;

    public FlagManager(MoveControl m, Robot r, int goalx, int goaly) {
        this.robot = r;
        this.mc = m;
        this.flagCnt = 1;
        this.flag[0] = new FlagCreator(r, this, 0, true, goalx, goaly);
        for (int i = 1; i < 6; ++i) {
            this.flag[i] = new FlagCreator(r, this, i, false, 0, 0);
        }
        this.createAllFlagMap();
    }

    public void drawFlag(Graphics g, Graphics offscreen) {
        for (int i = 0; i < this.flagCnt; ++i) {
            this.flag[i].paint(g, offscreen);
        }
    }

    public void addFlag() {
        if (this.flagCnt < 6) {
            ++this.flagCnt;
            this.robot.repaint();
            this.createAllFlagMap();
        }
    }

    public void deleteFlag() {
        if (this.flagCnt > 1) {
            --this.flagCnt;
            this.flag[this.flagCnt].init();
            this.robot.repaint();
            this.createAllFlagMap();
        }
    }

    public void deleteShowMsg(boolean b) {
        for (int i = 0; i < this.flagCnt; ++i) {
            this.flag[i].showMsg = false;
        }
    }

    public void moveFlag(int x, int y) {
        for (int i = 0; i < this.flagCnt; ++i) {
            boolean isDraw = true;
            for (int j = i + 1; j < this.flagCnt; ++j) {
                if (!this.flagTransferring[j]) continue;
                isDraw = false;
            }
            if ((x < this.flag[i].flagX[i] - 10 || x > this.flag[i].flagX[i] + 25 || y < this.flag[i].flagY[i] || y > this.flag[i].flagY[i] + 30) && !this.flagTransferring[i] || !isDraw) continue;
            if (x < 10) {
                x = 10;
            }
            if (y < 0) {
                y = 0;
            }
            if (x > 380) {
                x = 380;
            }
            if (y > 228) {
                y = 228;
            }
            this.flagTransferring[i] = true;
            this.flag[i].flagX[i] = x;
            this.flag[i].flagY[i] = y;
            this.flag[i].init();
            this.createAllFlagMap();
            break;
        }
    }

    public void setFlagTransferring(boolean b) {
        for (int i = 0; i < this.flagCnt; ++i) {
            this.flagTransferring[i] = b;
        }
    }

    public boolean isTouchFlag(int xx, int yy) {
        if (xx <= 0 || yy <= 0) {
            return false;
        }
        if (this.flagMap[xx][yy] > 0) {
            if (this.flagMap[xx][yy] == 10) {
                this.flag[0].showMsg = true;
                this.mc.goalFlag = true;
            } else {
                this.flag[this.flagMap[xx][yy]].showMsg = true;
            }
            return true;
        }
        return false;
    }

    public void createAllFlagMap() {
        for (int i = 0; i < 400; ++i) {
            for (int j = 0; j < 265; ++j) {
                this.flagMap[i][j] = 0;
            }
        }
        for (int i = 0; i < this.flagCnt; ++i) {
            this.flag[i].createFlagMap();
        }
    }
}

