/*
 * Decompiled with CFR 0.152.
 */
package edu;

import edu.Robot;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;

public class Map {
    public static final int WIDTH = 400;
    public static final int HEIGHT = 265;
    final Color MAP_BG_COLOR = new Color(143, 228, 255);
    int wallsLength;
    private static final int MAX_WALL_NUMBERS = 100;
    private Robot robot;
    private byte[][] hiddenMap = new byte[400][265];
    public int[][][] walls = new int[100][2][2];

    public void Map() {
    }

    public void init(Robot r) {
        this.robot = r;
        this.wallsLength = 0;
        this.initHiddenMap();
    }

    public void initHiddenMap() {
        for (int x = 0; x < 400; ++x) {
            for (int y = 0; y < 265; ++y) {
                this.hiddenMap[x][y] = 0;
            }
        }
        this.drawHiddenLine(0, 0, 399, 0);
        this.drawHiddenLine(0, 0, 0, 264);
        this.drawHiddenLine(399, 0, 399, 264);
        this.drawHiddenLine(0, 264, 399, 264);
        for (int i = 0; i < this.wallsLength; ++i) {
            if (i < this.wallsLength - 1 && (this.walls[i][0][0] == this.walls[i + 1][0][0] && this.walls[i][0][1] == this.walls[i + 1][0][1] && this.walls[i][1][0] == this.walls[i + 1][1][0] && this.walls[i][1][1] == this.walls[i + 1][1][1] || this.walls[i][1][0] == this.walls[i + 1][0][0] && this.walls[i][1][1] == this.walls[i + 1][0][1] && this.walls[i][0][0] == this.walls[i + 1][1][0] && this.walls[i][0][1] == this.walls[i + 1][1][1])) {
                ++i;
                continue;
            }
            this.drawHiddenLine(this.walls[i][0][0], this.walls[i][0][1], this.walls[i][1][0], this.walls[i][1][1]);
        }
        for (int i = 0; i < this.robot.headRadius; ++i) {
            this.thickenHiddenLine((byte)2);
        }
        for (int i = 0; i < this.robot.robotRadius - this.robot.headRadius; ++i) {
            this.thickenHiddenLine((byte)1);
        }
        for (int i = 0; i < this.wallsLength; ++i) {
            if (i >= this.wallsLength - 1 || (this.walls[i][0][0] != this.walls[i + 1][0][0] || this.walls[i][0][1] != this.walls[i + 1][0][1] || this.walls[i][1][0] != this.walls[i + 1][1][0] || this.walls[i][1][1] != this.walls[i + 1][1][1]) && (this.walls[i][1][0] != this.walls[i + 1][0][0] || this.walls[i][1][1] != this.walls[i + 1][0][1] || this.walls[i][0][0] != this.walls[i + 1][1][0] || this.walls[i][0][1] != this.walls[i + 1][1][1])) continue;
            this.drawHiddenLineForPD(this.walls[i][0][0], this.walls[i][0][1], this.walls[i][1][0], this.walls[i][1][1]);
            ++i;
        }
    }

    private void drawHiddenLine(int x1, int y1, int x2, int y2) {
        double x = x1;
        double y = y1;
        int dx = x2 - x1;
        int dy = y2 - y1;
        double ex = (double)dx / Math.sqrt(dx * dx + dy * dy);
        double ey = (double)dy / Math.sqrt(dx * dx + dy * dy);
        while ((int)(x + 0.5) != x2 || (int)(y + 0.5) != y2) {
            this.hiddenMap[(int)(x + 0.5)][(int)(y + 0.5)] = 1;
            x += ex;
            y += ey;
        }
    }

    private void drawHiddenLineForPD(int x1, int y1, int x2, int y2) {
        double x = x1;
        double y = y1;
        int dx = x2 - x1;
        int dy = y2 - y1;
        int lw = 5;
        double ex = (double)dx / Math.sqrt(dx * dx + dy * dy);
        double ey = (double)dy / Math.sqrt(dx * dx + dy * dy);
        while ((int)(x + 0.5) != x2 || (int)(y + 0.5) != y2) {
            for (int j = 0; j < lw; ++j) {
                if (this.hiddenMap[(int)(x + 0.5) + j][(int)(y + 0.5)] == 0) {
                    this.hiddenMap[(int)(x + 0.5) + j][(int)(y + 0.5)] = 3;
                }
                if (this.hiddenMap[(int)(x + 0.5)][(int)(y + 0.5) + j] == 0) {
                    this.hiddenMap[(int)(x + 0.5)][(int)(y + 0.5) + j] = 3;
                }
                if (this.hiddenMap[(int)(x + 0.5) + j][(int)(y + 0.5) + lw - 1] == 0) {
                    this.hiddenMap[(int)(x + 0.5) + j][(int)(y + 0.5) + lw - 1] = 3;
                }
                if (this.hiddenMap[(int)(x + 0.5) + lw - 1][(int)(y + 0.5) + j] != 0) continue;
                this.hiddenMap[(int)(x + 0.5) + lw - 1][(int)(y + 0.5) + j] = 3;
            }
            x += ex;
            y += ey;
        }
    }

    private void thickenHiddenLine(byte value) {
        for (int x = 1; x < 399; ++x) {
            for (int y = 1; y < 264; ++y) {
                if (0 != this.hiddenMap[x][y]) continue;
                if (0 < this.hiddenMap[x][y - 1]) {
                    this.hiddenMap[x][y] = (byte)(-1 * value);
                    continue;
                }
                if (0 < this.hiddenMap[x][y + 1]) {
                    this.hiddenMap[x][y] = (byte)(-1 * value);
                    continue;
                }
                if (0 < this.hiddenMap[x - 1][y]) {
                    this.hiddenMap[x][y] = (byte)(-1 * value);
                    continue;
                }
                if (0 >= this.hiddenMap[x + 1][y]) continue;
                this.hiddenMap[x][y] = (byte)(-1 * value);
            }
        }
        for (int x = 1; x < 399; ++x) {
            for (int y = 1; y < 264; ++y) {
                if (0 <= this.hiddenMap[x][y]) continue;
                this.hiddenMap[x][y] = (byte)(this.hiddenMap[x][y] * -1);
            }
        }
    }

    public void paint(Graphics g, Graphics offscreen) {
        int lw = 4;
        offscreen.setColor(Color.gray);
        for (int i = 0; i < this.wallsLength - 1; ++i) {
            if ((this.walls[i][0][0] != this.walls[i + 1][0][0] || this.walls[i][0][1] != this.walls[i + 1][0][1] || this.walls[i][1][0] != this.walls[i + 1][1][0] || this.walls[i][1][1] != this.walls[i + 1][1][1]) && (this.walls[i][1][0] != this.walls[i + 1][0][0] || this.walls[i][1][1] != this.walls[i + 1][0][1] || this.walls[i][0][0] != this.walls[i + 1][1][0] || this.walls[i][0][1] != this.walls[i + 1][1][1])) continue;
            for (int j = 0; j < lw; ++j) {
                offscreen.drawLine(this.walls[i][0][0] + j, this.walls[i][0][1], this.walls[i][1][0] + j, this.walls[i][1][1]);
                offscreen.drawLine(this.walls[i][0][0], this.walls[i][0][1] + j, this.walls[i][1][0], this.walls[i][1][1] + j);
                offscreen.drawLine(this.walls[i][0][0] + j, this.walls[i][0][1] + lw - 1, this.walls[i][1][0] + j, this.walls[i][1][1] + lw - 1);
                offscreen.drawLine(this.walls[i][0][0] + lw - 1, this.walls[i][0][1] + j, this.walls[i][1][0] + lw - 1, this.walls[i][1][1] + j);
            }
            ++i;
        }
        offscreen.setColor(Color.black);
        for (int i = 0; i < this.wallsLength; ++i) {
            if (i < this.wallsLength - 1 && (this.walls[i][0][0] == this.walls[i + 1][0][0] && this.walls[i][0][1] == this.walls[i + 1][0][1] && this.walls[i][1][0] == this.walls[i + 1][1][0] && this.walls[i][1][1] == this.walls[i + 1][1][1] || this.walls[i][1][0] == this.walls[i + 1][0][0] && this.walls[i][1][1] == this.walls[i + 1][0][1] && this.walls[i][0][0] == this.walls[i + 1][1][0] && this.walls[i][0][1] == this.walls[i + 1][1][1])) {
                ++i;
                continue;
            }
            offscreen.drawLine(this.walls[i][0][0], this.walls[i][0][1], this.walls[i][1][0], this.walls[i][1][1]);
        }
        offscreen.setColor(Color.yellow);
    }

    public boolean isSensored(Point p) {
        if (p.x <= 0 || p.y <= 0) {
            return true;
        }
        if (p.x > 399 || p.y > 264) {
            return true;
        }
        return 2 == this.hiddenMap[p.x][p.y];
    }

    public boolean isSensoredPD(Point p) {
        if (p.x <= 0 || p.y <= 0) {
            return true;
        }
        if (p.x > 399 || p.y > 264) {
            return true;
        }
        return 3 == this.hiddenMap[p.x][p.y];
    }

    public boolean isCollided(int x, int y) {
        if (x <= 0 || y <= 0) {
            return true;
        }
        if (x > 399 || y > 264) {
            return true;
        }
        return 1 == this.hiddenMap[x][y];
    }

    public void createMap() {
        if (this.robot.mapEditMode) {
            this.robot.wm.awtbutton[17].setLabel("\u30b3\u30fc\u30b9\u4f5c\u6210");
            this.robot.mapEditMode = false;
            this.robot.map.initHiddenMap();
            this.robot.redrawMap();
            this.robot.wm.setMapEditMsg("");
            this.robot.wm.awtbutton[18].disable();
            this.robot.wm.awtbutton[19].disable();
            this.robot.wm.awtbutton[20].disable();
        } else {
            this.robot.wm.awtbutton[17].setLabel("\u4f5c\u6210\u7d42\u4e86");
            this.robot.mapEditMode = true;
            this.robot.redrawMap();
            this.robot.wm.setMapEditMsg("\u30b3\u30fc\u30b9\u4f5c\u6210");
            this.robot.wm.awtbutton[18].enable();
            this.robot.wm.awtbutton[19].enable();
            this.robot.wm.awtbutton[20].enable();
        }
    }

    public void deleteMap() {
        if (this.robot.mapEditMode) {
            if (this.robot.lineCnt > 0) {
                --this.robot.lineCnt;
                this.walls[this.robot.lineCnt][0][0] = 0;
                this.walls[this.robot.lineCnt][0][1] = 0;
                this.walls[this.robot.lineCnt][1][0] = 0;
                this.walls[this.robot.lineCnt][1][1] = 0;
                this.wallsLength = this.robot.lineCnt;
                this.robot.repaint();
            }
        } else {
            this.robot.wm.outputErrMsg("\u8ff7\u8def\u4f5c\u6210\u30dc\u30bf\u30f3\u3092\u62bc\u3057\u3066\u304f\u3060\u3055\u3044");
        }
    }
}

