/*
 * Decompiled with CFR 0.152.
 */
package edu;

import edu.FlagManager;
import edu.Map;
import edu.MoveControl;
import edu.ProgData;
import edu.WaoMain;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;

public class Robot
extends Canvas {
    public int robotRadius;
    public int headRadius;
    public int PD_headRadius;
    public int unitLength;
    private final Color ROBOT_COLOR = Color.blue;
    private final double SENSOR_ANGLE = 0.483321946706122;
    private final double PD_SENSOR_ANGLE = 0.7853981633974483;
    private final Color SENSOR_HEAD_COLOR = Color.white;
    private final Color SENSOR_COLLIDED_COLOR = Color.red;
    private final Color PD_SENSOR_HEAD_COLOR = Color.blue;
    private final Color PD_SENSOR_COLLIDED_COLOR = Color.yellow;
    private int sensorLength;
    private int headRadius2;
    private int robotRadius2;
    private final int DRAW_LENGTH = 2;
    private final double UNIT_ANGLE = 0.39269908169872414;
    private final int N_ANGLE = 2;
    private final double DRAW_ANGLE = 0.19634954084936207;
    public final int CANVAS_W = 400;
    public final int CANVAS_H = 265;
    public final int tailLines = 50;
    private final long STOPTIME = 300L;
    private boolean leftSensorState = false;
    private boolean rightSensorState = false;
    private boolean LFSensorState = false;
    private boolean RFSensorState = false;
    private boolean LBSensorState = false;
    private boolean RBSensorState = false;
    private Color sensorLeftColor = this.SENSOR_HEAD_COLOR;
    private Color sensorRightColor = this.SENSOR_HEAD_COLOR;
    private Color sensorLFColor = this.PD_SENSOR_HEAD_COLOR;
    private Color sensorRFColor = this.PD_SENSOR_HEAD_COLOR;
    private Color sensorLBColor = this.PD_SENSOR_HEAD_COLOR;
    private Color sensorRBColor = this.PD_SENSOR_HEAD_COLOR;
    private Graphics offscreen;
    private Image image;
    int lineCnt = 0;
    private int startPointx = 0;
    private int startPointy = 0;
    private int dragPointx = 0;
    private int dragPointy = 0;
    private int endPoint = 0;
    private int endPointy = 0;
    private boolean showDragLine = false;
    public boolean mapEditMode = false;
    public int[][] tailStart = new int[50][2];
    public int[][] tailEnd = new int[50][2];
    int cnt = 0;
    Map map = new Map();
    WaoMain wm;
    MoveControl mc;
    ProgData pd = new ProgData();
    FlagManager flagManager;
    public int x;
    public int y;
    private int posX;
    private int posY;
    public double dircAngle;
    private int centerX;
    private int centerY;
    private int resetx = this.x;
    private int resety = this.y;
    private int resetGoalX;
    private int resetGoalY;
    private double resetAngle = this.dircAngle;
    private Point p2 = new Point();
    private Point p4 = new Point();
    private Point pLF = new Point();
    private Point pRF = new Point();
    private Point pLB = new Point();
    private Point pRB = new Point();
    boolean isTransferring = false;

    public Robot(MoveControl m, WaoMain w, Image i, Graphics off) {
        this.mc = m;
        this.wm = w;
        this.image = i;
        this.offscreen = off;
        int goalx = 20;
        int goaly = 30;
        try {
            this.actionPartInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.map.init(this);
        this.lineCnt = this.map.wallsLength;
        this.robotDataInit();
        this.flagManager = new FlagManager(this.mc, this, goalx, goaly);
        this.robotInit();
        this.map.initHiddenMap();
    }

    public void paint(Graphics g) {
        this.offscreen.setColor(this.map.MAP_BG_COLOR);
        this.offscreen.fillRect(0, 0, 400, 265);
        this.map.paint(g, this.offscreen);
        this.flagManager.drawFlag(g, this.offscreen);
        this.drawTail(g, this.offscreen);
        this.offscreen.setColor(this.ROBOT_COLOR);
        this.offscreen.fillOval(this.x, this.y, this.robotRadius2, this.robotRadius2);
        this.offscreen.setColor(this.sensorLFColor);
        this.offscreen.fillOval(this.pLF.x - this.PD_headRadius, this.pLF.y - this.PD_headRadius, this.PD_headRadius * 2, this.PD_headRadius * 2);
        this.offscreen.setColor(this.sensorRFColor);
        this.offscreen.fillOval(this.pRF.x - this.PD_headRadius, this.pRF.y - this.PD_headRadius, this.PD_headRadius * 2, this.PD_headRadius * 2);
        this.offscreen.setColor(this.sensorLBColor);
        this.offscreen.fillOval(this.pLB.x - this.PD_headRadius, this.pLB.y - this.PD_headRadius, this.PD_headRadius * 2, this.PD_headRadius * 2);
        this.offscreen.setColor(this.sensorRBColor);
        this.offscreen.fillOval(this.pRB.x - this.PD_headRadius, this.pRB.y - this.PD_headRadius, this.PD_headRadius * 2, this.PD_headRadius * 2);
        for (int i = 1; i <= 5; ++i) {
            this.offscreen.setColor(this.sensorLeftColor);
            this.offscreen.drawArc(this.p2.x + (this.centerX - this.p2.x) * (i - 1) / 8 - (this.headRadius - (i - 1)), this.p2.y + (this.centerY - this.p2.y) * (i - 1) / 8 - (this.headRadius - (i - 1)), (this.headRadius - (i - 1)) * 2, (this.headRadius - (i - 1)) * 2, (int)(this.dircAngle / Math.PI * 180.0 - 45.0), 150);
            this.offscreen.setColor(this.sensorRightColor);
            this.offscreen.drawArc(this.p4.x + (this.centerX - this.p4.x) * (i - 1) / 8 - (this.headRadius - (i - 1)), this.p4.y + (this.centerY - this.p4.y) * (i - 1) / 8 - (this.headRadius - (i - 1)), (this.headRadius - (i - 1)) * 2, (this.headRadius - (i - 1)) * 2, (int)(this.dircAngle / Math.PI * 180.0 + 45.0), -150);
        }
        if (this.mapEditMode) {
            this.drawGrid(g, this.offscreen);
            if (this.showDragLine) {
                this.offscreen.drawLine(this.startPointx, this.startPointy, this.dragPointx, this.dragPointy);
            }
        }
        g.drawImage(this.image, 0, 0, this);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public boolean forward() {
        double cos = Math.cos(this.dircAngle);
        double sin = Math.sin(this.dircAngle);
        for (int i = 2; i < this.unitLength; i += 2) {
            int nextX = this.posX + (int)(cos * (double)i);
            int nextY = this.posY - (int)(sin * (double)i);
            Point[] nextSensor = this.getSensorXY(nextX, nextY, 0.0);
            if (this.updateSensorState(nextSensor) || this.map.isCollided(nextX + this.robotRadius, nextY + this.robotRadius)) {
                return false;
            }
            this.x = nextX;
            this.y = nextY;
            this.flagManager.isTouchFlag(this.x, this.y);
            this.p2 = nextSensor[0];
            this.p4 = nextSensor[1];
            this.pLF = nextSensor[2];
            this.pRF = nextSensor[3];
            this.pLB = nextSensor[4];
            this.pRB = nextSensor[5];
            this.setTail(1, this.x, this.y);
            this.repaint();
            this.mc.delay();
        }
        this.posX = this.x;
        this.posY = this.y;
        return true;
    }

    public boolean backward() {
        double cos = Math.cos(this.dircAngle);
        double sin = Math.sin(this.dircAngle);
        for (int i = 2; i < this.unitLength; i += 2) {
            int nextX = this.posX - (int)(cos * (double)i);
            int nextY = this.posY + (int)(sin * (double)i);
            Point[] nextSensor = this.getSensorXY(nextX, nextY, 0.0);
            if (this.updateSensorState(nextSensor) || this.map.isCollided(nextX + this.robotRadius, nextY + this.robotRadius)) {
                i -= 2;
                return false;
            }
            this.x = nextX;
            this.y = nextY;
            this.flagManager.isTouchFlag(this.x, this.y);
            this.p2 = nextSensor[0];
            this.p4 = nextSensor[1];
            this.pLF = nextSensor[2];
            this.pRF = nextSensor[3];
            this.pLB = nextSensor[4];
            this.pRB = nextSensor[5];
            this.setTail(1, this.x, this.y);
            this.repaint();
            this.mc.delay();
        }
        this.posX = this.x;
        this.posY = this.y;
        return true;
    }

    public boolean rotateLeft() {
        double counter = 0.19634954084936207;
        for (int i = 0; i < 2; ++i) {
            Point[] nextSensor = this.getSensorXY(this.x, this.y, counter);
            if (!this.updateSensorState(nextSensor)) {
                this.p2 = nextSensor[0];
                this.p4 = nextSensor[1];
                this.pLF = nextSensor[2];
                this.pRF = nextSensor[3];
                this.pLB = nextSensor[4];
                this.pRB = nextSensor[5];
                this.repaint();
                counter += 0.19634954084936207;
            } else {
                counter -= 0.19634954084936207;
                return false;
            }
            this.mc.delay();
        }
        this.dircAngle = this.dircAngle + counter - 0.19634954084936207;
        return true;
    }

    public boolean rotateRight() {
        double counter = 0.19634954084936207;
        for (int i = 0; i < 2; ++i) {
            Point[] nextSensor = this.getSensorXY(this.x, this.y, -counter);
            if (!this.updateSensorState(nextSensor)) {
                this.p2 = nextSensor[0];
                this.p4 = nextSensor[1];
                this.pLF = nextSensor[2];
                this.pRF = nextSensor[3];
                this.pLB = nextSensor[4];
                this.pRB = nextSensor[5];
                this.repaint();
                counter += 0.19634954084936207;
            } else {
                counter -= 0.19634954084936207;
                return false;
            }
            this.mc.delay();
        }
        this.dircAngle = this.dircAngle - counter + 0.19634954084936207;
        return true;
    }

    private boolean updateSensorState(Point[] p) {
        boolean ret = false;
        this.leftSensorState = false;
        this.rightSensorState = false;
        if (this.map.isSensored(p[0])) {
            this.leftSensorState = true;
            ret = true;
            this.sensorLeftColor = this.SENSOR_COLLIDED_COLOR;
        } else {
            this.sensorLeftColor = this.SENSOR_HEAD_COLOR;
        }
        if (this.map.isSensored(p[1])) {
            this.rightSensorState = true;
            ret = true;
            this.sensorRightColor = this.SENSOR_COLLIDED_COLOR;
        } else {
            this.sensorRightColor = this.SENSOR_HEAD_COLOR;
        }
        if (this.map.isSensoredPD(p[2])) {
            this.LFSensorState = true;
            this.sensorLFColor = this.PD_SENSOR_COLLIDED_COLOR;
        } else {
            this.LFSensorState = false;
            this.sensorLFColor = this.PD_SENSOR_HEAD_COLOR;
        }
        if (this.map.isSensoredPD(p[3])) {
            this.RFSensorState = true;
            this.sensorRFColor = this.PD_SENSOR_COLLIDED_COLOR;
        } else {
            this.RFSensorState = false;
            this.sensorRFColor = this.PD_SENSOR_HEAD_COLOR;
        }
        if (this.map.isSensoredPD(p[4])) {
            this.LBSensorState = true;
            this.sensorLBColor = this.PD_SENSOR_COLLIDED_COLOR;
        } else {
            this.LBSensorState = false;
            this.sensorLBColor = this.PD_SENSOR_HEAD_COLOR;
        }
        if (this.map.isSensoredPD(p[5])) {
            this.RBSensorState = true;
            this.sensorRBColor = this.PD_SENSOR_COLLIDED_COLOR;
        } else {
            this.RBSensorState = false;
            this.sensorRBColor = this.PD_SENSOR_HEAD_COLOR;
        }
        return ret;
    }

    public boolean isLeftSensored() {
        return this.leftSensorState;
    }

    public boolean isRightSensored() {
        return this.rightSensorState;
    }

    public boolean isLFSensored() {
        return this.LFSensorState;
    }

    public boolean isLBSensored() {
        return this.LBSensorState;
    }

    public boolean isRFSensored() {
        return this.RFSensorState;
    }

    public boolean isRBSensored() {
        return this.RBSensorState;
    }

    public int getSensorState() {
        int ret = 0;
        if (this.isLeftSensored() && this.isRightSensored()) {
            ret = 3;
        } else {
            if (this.isLeftSensored()) {
                ret = 1;
            }
            if (this.isRightSensored()) {
                ret = 2;
            }
        }
        return ret;
    }

    public int[] getSensorStatePD() {
        int[] ret = new int[4];
        ret[3] = 0;
        ret[2] = 0;
        ret[1] = 0;
        ret[0] = 0;
        if (this.isLFSensored()) {
            ret[0] = 1;
        }
        if (this.isRFSensored()) {
            ret[1] = 1;
        }
        if (this.isLBSensored()) {
            ret[2] = 1;
        }
        if (this.isRBSensored()) {
            ret[3] = 1;
        }
        return ret;
    }

    public int getSensorStatePD_FRONT() {
        int ret = 0;
        if (this.isLFSensored() && this.isRFSensored()) {
            ret = 3;
        } else {
            if (this.isLFSensored()) {
                ret = 1;
            }
            if (this.isRFSensored()) {
                ret = 2;
            }
        }
        return ret;
    }

    public int getSensorStatePD_REAR() {
        int ret = 0;
        if (this.isLBSensored() && this.isRBSensored()) {
            ret = 3;
        } else {
            if (this.isLBSensored()) {
                ret = 1;
            }
            if (this.isRBSensored()) {
                ret = 2;
            }
        }
        return ret;
    }

    public Point[] getSensorXY(int x, int y, double angle) {
        Point p2 = new Point();
        Point p4 = new Point();
        Point pLF = new Point();
        Point pRF = new Point();
        Point pLB = new Point();
        Point pRB = new Point();
        this.centerX = x + this.robotRadius;
        this.centerY = y + this.robotRadius;
        int length = this.robotRadius + this.sensorLength;
        double angle1 = this.dircAngle + angle;
        double totalAngle1 = 0.483321946706122 + angle1;
        double totalAngle2 = -0.483321946706122 + angle1;
        p2.x = (int)((double)this.centerX + Math.cos(totalAngle1) * (double)length);
        p2.y = (int)((double)this.centerY - Math.sin(totalAngle1) * (double)length);
        p4.x = (int)((double)this.centerX + Math.cos(totalAngle2) * (double)length);
        p4.y = (int)((double)this.centerY - Math.sin(totalAngle2) * (double)length);
        pLF.x = (int)((double)this.centerX + Math.cos(0.7853981633974483 + angle1) * (double)this.robotRadius);
        pLF.y = (int)((double)this.centerY - Math.sin(0.7853981633974483 + angle1) * (double)this.robotRadius);
        pRF.x = (int)((double)this.centerX + Math.cos(-0.7853981633974483 + angle1) * (double)this.robotRadius);
        pRF.y = (int)((double)this.centerY - Math.sin(-0.7853981633974483 + angle1) * (double)this.robotRadius);
        pLB.x = (int)((double)this.centerX + Math.cos(0.7853981633974483 + angle1 + 1.5707963267948966) * (double)this.robotRadius);
        pLB.y = (int)((double)this.centerY - Math.sin(0.7853981633974483 + angle1 + 1.5707963267948966) * (double)this.robotRadius);
        pRB.x = (int)((double)this.centerX + Math.cos(-0.7853981633974483 + angle1 - 1.5707963267948966) * (double)this.robotRadius);
        pRB.y = (int)((double)this.centerY - Math.sin(-0.7853981633974483 + angle1 - 1.5707963267948966) * (double)this.robotRadius);
        Point[] ret = new Point[]{p2, p4, pLF, pRF, pLB, pRB};
        return ret;
    }

    private void actionPartInit() throws Exception {
        this.setSize(new Dimension(400, 265));
        Point[] p = this.getSensorXY(this.x, this.y, 0.0);
        this.p2 = p[0];
        this.p4 = p[1];
        this.addMouseListener(new 1());
        this.addMouseMotionListener(new 2());
    }

    public void robotInit() {
        this.posX = this.x;
        this.posY = this.y;
        this.resetx = this.x;
        this.resety = this.y;
        this.resetAngle = this.dircAngle;
        Point[] nextSensor = this.getSensorXY(this.x, this.y, 0.0);
        this.p2 = nextSensor[0];
        this.p4 = nextSensor[1];
        this.pLF = nextSensor[2];
        this.pRF = nextSensor[3];
        this.pLB = nextSensor[4];
        this.pRB = nextSensor[5];
        this.updateSensorState(nextSensor);
        this.resetGoalX = this.flagManager.flag[0].flagX[0];
        this.resetGoalY = this.flagManager.flag[0].flagY[0];
        for (int i = 0; i < this.flagManager.flagCnt; ++i) {
            this.flagManager.flag[i].init();
        }
        this.flagManager.createAllFlagMap();
    }

    void this_mouseDragged(MouseEvent e) {
        int mouseX = e.getX();
        int mouseY = e.getY();
        boolean isDraw = true;
        for (int i = 0; i < 6; ++i) {
            if (!this.flagManager.flagTransferring[i]) continue;
            isDraw = false;
        }
        if ((mouseX >= this.x && mouseX <= this.x + this.robotRadius * 2 && mouseY >= this.y && mouseY <= this.y + this.robotRadius * 2 || this.isTransferring) && isDraw) {
            this.isTransferring = true;
            this.x = mouseX - this.robotRadius;
            this.y = mouseY - this.robotRadius;
            if (this.x < 1) {
                this.x = 1;
            }
            if (this.y < 1) {
                this.y = 1;
            }
            if (this.x > 400 - 2 * this.robotRadius + 1) {
                this.x = 400 - 2 * this.robotRadius + 1;
            }
            if (this.y > 265 - 2 * this.robotRadius + 1) {
                this.y = 265 - 2 * this.robotRadius + 1;
            }
            this.posX = this.x;
            this.posY = this.y;
            Point[] nextSensor = this.getSensorXY(this.x, this.y, 0.0);
            this.p2 = nextSensor[0];
            this.p4 = nextSensor[1];
            this.pLF = nextSensor[2];
            this.pRF = nextSensor[3];
            this.pLB = nextSensor[4];
            this.pRB = nextSensor[5];
            this.updateSensorState(nextSensor);
        } else if (mouseX >= this.x - 40 && mouseX <= this.x + this.robotRadius * 2 + 40 && mouseY >= this.y - 40 && mouseY <= this.y + this.robotRadius * 2 + 40 && isDraw) {
            this.dircAngle = Math.atan2(mouseX - this.x - this.robotRadius, mouseY - this.y - this.robotRadius) - 1.5707963267948966;
            this.dircAngle = 0.39269908169872414 * (double)((int)(this.dircAngle / 0.39269908169872414));
            Point[] nextSensor = this.getSensorXY(this.x, this.y, 0.0);
            this.p2 = nextSensor[0];
            this.p4 = nextSensor[1];
            this.pLF = nextSensor[2];
            this.pRF = nextSensor[3];
            this.pLB = nextSensor[4];
            this.pRB = nextSensor[5];
            this.updateSensorState(nextSensor);
        } else {
            this.flagManager.moveFlag(mouseX, mouseY);
        }
        this.repaint();
    }

    void this_mouseReleased(MouseEvent e) {
        this.isTransferring = false;
        this.flagManager.setFlagTransferring(false);
    }

    public void robotReset() {
        this.x = this.resetx;
        this.y = this.resety;
        this.dircAngle = this.resetAngle;
        this.flagManager.flag[0].flagX[0] = this.resetGoalX;
        this.flagManager.flag[0].flagY[0] = this.resetGoalY;
        this.robotInit();
        for (int i = 0; i < 50; ++i) {
            this.tailStart[i][0] = 0;
            this.tailStart[i][1] = 0;
            this.tailEnd[i][0] = 0;
            this.tailEnd[i][1] = 0;
        }
        this.cnt = 0;
        this.repaint();
    }

    void mousePressedDrawLine(MouseEvent e) {
        this.startPointx = e.getX() + this.robotRadius - (e.getX() + this.robotRadius) % (2 * this.robotRadius);
        this.startPointy = e.getY() + this.robotRadius - (e.getY() + this.robotRadius) % (2 * this.robotRadius);
        if (this.lineCnt < 100) {
            this.map.walls[this.lineCnt][0][0] = this.startPointx >= 1 && this.startPointx <= 399 ? this.startPointx : (this.startPointx <= 1 ? 1 : 399);
            this.map.walls[this.lineCnt][0][1] = this.startPointy >= 1 && this.startPointy <= 264 ? this.startPointy : (this.startPointy <= 1 ? 1 : 264);
        }
    }

    void mouseDraggedDrawLine(MouseEvent e) {
        this.dragPointx = e.getX() + this.robotRadius - (e.getX() + this.robotRadius) % (2 * this.robotRadius);
        this.dragPointy = e.getY() + this.robotRadius - (e.getY() + this.robotRadius) % (2 * this.robotRadius);
        this.showDragLine = true;
        this.repaint();
    }

    void mouseReleasedDrawLine(MouseEvent e) {
        int xx = 0;
        int yy = 0;
        xx = e.getX() + this.robotRadius - (e.getX() + this.robotRadius) % (2 * this.robotRadius);
        yy = e.getY() + this.robotRadius - (e.getY() + this.robotRadius) % (2 * this.robotRadius);
        if (this.lineCnt < 100) {
            this.map.walls[this.lineCnt][1][0] = xx >= 1 && xx <= 399 ? xx : (xx <= 1 ? 1 : 399);
            this.map.walls[this.lineCnt][1][1] = yy >= 1 && yy <= 264 ? yy : (yy <= 1 ? 1 : 264);
            this.showDragLine = false;
            if (this.map.walls[this.lineCnt][0][0] != this.map.walls[this.lineCnt][1][0] || this.map.walls[this.lineCnt][0][1] != this.map.walls[this.lineCnt][1][1]) {
                ++this.lineCnt;
            }
            this.map.wallsLength = this.lineCnt;
            this.repaint();
        }
    }

    private void drawTail(Graphics g, Graphics off) {
        off.setColor(Color.blue);
        for (int i = 0; i < 50; ++i) {
            off.drawLine(this.tailStart[i][0], this.tailStart[i][1], this.tailEnd[i][0], this.tailEnd[i][1]);
        }
    }

    private void drawGrid(Graphics g, Graphics off) {
        off.setColor(Color.gray);
        if (this.mapEditMode) {
            for (int i = 0; i < 400; i += 2 * this.robotRadius) {
                for (int j = 0; j < 265; j += 2 * this.robotRadius) {
                    off.fillRect(i, j, 2, 2);
                }
            }
        }
    }

    public void setCollidedColor(int state) {
        if (state == 3) {
            this.sensorLeftColor = this.SENSOR_COLLIDED_COLOR;
            this.sensorRightColor = this.SENSOR_COLLIDED_COLOR;
        } else {
            if (state == 1) {
                this.sensorLeftColor = this.SENSOR_COLLIDED_COLOR;
            }
            if (state == 2) {
                this.sensorRightColor = this.SENSOR_COLLIDED_COLOR;
            }
        }
        if (state == 0) {
            this.sensorLeftColor = this.SENSOR_HEAD_COLOR;
            this.sensorRightColor = this.SENSOR_HEAD_COLOR;
        }
    }

    public void setCollidedColorPD(int[] state) {
        this.sensorLFColor = this.sensorRFColor = this.PD_SENSOR_HEAD_COLOR;
        this.sensorLBColor = this.sensorRBColor = this.PD_SENSOR_HEAD_COLOR;
        if (state[0] == 1) {
            this.sensorLFColor = this.PD_SENSOR_COLLIDED_COLOR;
        }
        if (state[1] == 1) {
            this.sensorRFColor = this.PD_SENSOR_COLLIDED_COLOR;
        }
        if (state[2] == 1) {
            this.sensorLBColor = this.PD_SENSOR_COLLIDED_COLOR;
        }
        if (state[3] == 1) {
            this.sensorRBColor = this.PD_SENSOR_COLLIDED_COLOR;
        }
    }

    public void clearCollidedColor() {
        this.sensorLeftColor = this.SENSOR_HEAD_COLOR;
        this.sensorRightColor = this.SENSOR_HEAD_COLOR;
    }

    public void redrawMap() {
        this.repaint();
    }

    public void setTail(int whichPoint, int xx, int yy) {
        if (this.cnt >= 50) {
            this.cnt = 0;
        }
        if (whichPoint == 0) {
            this.tailStart[this.cnt][0] = this.posX + this.robotRadius;
            this.tailStart[this.cnt][1] = this.posY + this.robotRadius;
            this.tailEnd[this.cnt][0] = this.tailStart[this.cnt][0];
            this.tailEnd[this.cnt][1] = this.tailStart[this.cnt][1];
        } else {
            this.tailEnd[this.cnt][0] = xx + this.robotRadius;
            this.tailEnd[this.cnt][1] = yy + this.robotRadius;
        }
    }

    public void robotSizeInit(int size, int length) {
        this.robotRadius = size;
        this.unitLength = length;
        this.sensorLength = size * 2 / 5;
        this.headRadius = size / 3;
        this.PD_headRadius = size / 6;
        this.headRadius2 = 2 * this.headRadius;
        this.robotRadius2 = 2 * this.robotRadius;
        Point[] nextSensor = this.getSensorXY(this.x, this.y, 0.0);
        this.p2 = nextSensor[0];
        this.p4 = nextSensor[1];
        this.pLF = nextSensor[2];
        this.pRF = nextSensor[3];
        this.pLB = nextSensor[4];
        this.pRB = nextSensor[5];
        this.redrawMap();
    }

    private void robotDataInit() {
        this.x = 190;
        this.y = 220;
        this.robotRadius = 12;
        this.dircAngle = 1.5707963267948966;
        this.unitLength = 6;
        this.headRadius = this.robotRadius / 3;
        this.headRadius2 = 2 * this.headRadius;
        this.robotRadius2 = 2 * this.robotRadius;
        this.sensorLength = this.robotRadius * 2 / 5;
        this.PD_headRadius = this.robotRadius / 6;
        this.posX = this.x;
        this.posY = this.y;
        this.resetx = this.x;
        this.resety = this.y;
    }

    public void stopHere() {
        Point[] posSensor = this.getSensorXY(this.posX, this.posY, 0.0);
        this.updateSensorState(posSensor);
        try {
            Thread.sleep(300L);
        }
        catch (Exception e) {
            System.out.println(String.valueOf("in stopHere e=").concat(String.valueOf(e)));
        }
    }

    class 2
    extends MouseMotionAdapter {
        public void mouseDragged(MouseEvent e) {
            if (!Robot.this.mapEditMode) {
                if (Robot.this.wm.simulator_mode == 2) {
                    Robot.this.this_mouseDragged(e);
                } else {
                    Robot.this.this_mouseDragged(e);
                }
            } else {
                Robot.this.mouseDraggedDrawLine(e);
            }
        }

        2() {
        }
    }

    class 1
    extends MouseAdapter {
        public void mouseReleased(MouseEvent e) {
            if (!Robot.this.mapEditMode) {
                Robot.this.this_mouseReleased(e);
            } else {
                Robot.this.mouseReleasedDrawLine(e);
            }
        }

        public void mousePressed(MouseEvent e) {
            if (Robot.this.mapEditMode) {
                Robot.this.mousePressedDrawLine(e);
            }
        }

        1() {
        }
    }
}

