/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.scene.media.AudioClip;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Mixer;

public class Pomodoro
extends Application {
    private int counter;
    private int timeleft;
    private int s;
    private int hrs;
    private int min;
    private int sec;
    private int initMin;
    private int tfCounter;
    private int checkLength = 4;
    private MyRunnable runnable;
    private Thread thread;
    private Label lbTime;
    private Label lbWarn;
    private Label lbStatus;
    private Label lbSetting;
    private Label lbMins;
    private Label t1;
    private Label t2;
    private TextField tf;
    private Stage primaryStage;
    private Stage settingStage;
    private ButtonEventHandler bh;
    private Button btPlay;
    private Button btReset;
    private Button btSetting;
    private AudioClip audio;
    private Scene primaryScene;
    private Scene settingScene;
    private MenuBar mb;
    private CheckMenuItem mi1;
    private boolean darkMode;
    private boolean running;

    public void start(Stage stage) throws Exception {
        this.timeleft = 1500;
        this.counter = 0;
        this.initMin = 25;
        this.lbStatus = new Label("Pomodoro");
        this.lbStatus.setFont(new Font("YuGothic Medium", 24.0));
        this.lbTime = new Label("25:00");
        this.lbTime.setFont(new Font("YuGothic Medium", 76.0));
        this.lbTime.setTextFill((Paint)Color.web((String)"#8cc030"));
        this.btSetting = new Button();
        this.btSetting.setGraphic((Node)new ImageView("setting.png"));
        this.btSetting.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.web((String)"#eee"), null, null)}));
        this.btSetting.setId("setting");
        this.btPlay = new Button("PLAY");
        this.btPlay.setGraphic((Node)new ImageView("play.png"));
        this.btPlay.setId("play");
        this.btPlay.setFont(new Font("YuGothic Bold", 15.0));
        this.btPlay.setTextFill((Paint)Color.web((String)"#fff"));
        this.btPlay.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.web((String)"#607D8B"), null, null)}));
        this.btPlay.setPrefSize(120.0, 50.0);
        this.btReset = new Button("RESET");
        this.btReset.setGraphic((Node)new ImageView("reset.png"));
        this.btReset.setId("reset");
        this.btReset.setFont(new Font("YuGothic Bold", 15.0));
        this.btReset.setTextFill((Paint)Color.web((String)"#fff"));
        this.btReset.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.web((String)"#607D8B"), null, null)}));
        this.btReset.setPrefSize(120.0, 50.0);
        this.bh = new ButtonEventHandler();
        this.btPlay.addEventHandler(ActionEvent.ANY, (EventHandler)this.bh);
        this.btReset.addEventHandler(ActionEvent.ANY, (EventHandler)this.bh);
        this.btSetting.addEventHandler(ActionEvent.ANY, (EventHandler)this.bh);
        GridPane gridPane = new GridPane();
        gridPane.add((Node)this.btPlay, 0, 0);
        gridPane.add((Node)this.btReset, 1, 0);
        gridPane.setBackground(null);
        gridPane.setPadding(new Insets(0.0, 0.0, 25.0, 0.0));
        gridPane.setHgap(10.0);
        gridPane.setAlignment(Pos.CENTER);
        BorderPane borderPane = new BorderPane();
        borderPane.setTop((Node)this.btSetting);
        BorderPane.setAlignment((Node)this.btSetting, (Pos)Pos.CENTER_RIGHT);
        borderPane.setPadding(new Insets(10.0, 10.0, 50.0, 0.0));
        VBox vBox = new VBox();
        ObservableList observableList = vBox.getChildren();
        observableList.add((Object)borderPane);
        observableList.add((Object)this.lbStatus);
        observableList.add((Object)this.lbTime);
        observableList.addAll((Object[])new Node[]{gridPane});
        vBox.setBackground(null);
        vBox.setSpacing(20.0);
        vBox.setAlignment(Pos.TOP_CENTER);
        this.primaryScene = new Scene((Parent)vBox, 500.0, 500.0);
        this.primaryScene.setFill((Paint)Color.web((String)"#eee"));
        this.primaryStage = new Stage();
        this.primaryStage.setScene(this.primaryScene);
        this.primaryStage.setTitle("\u30dd\u30e2\u30c9\u30fc\u30ed");
        this.primaryStage.setResizable(false);
        this.primaryStage.show();
    }

    public static void main(String[] stringArray) {
        Pomodoro.launch((String[])stringArray);
    }

    private class MyEventHandler
    implements EventHandler<ActionEvent> {
        private MyEventHandler() {
        }

        public void handle(ActionEvent actionEvent) {
            CheckMenuItem checkMenuItem = (CheckMenuItem)actionEvent.getTarget();
            if (checkMenuItem.isSelected()) {
                Pomodoro.this.primaryScene.setFill((Paint)Color.web((String)"#303030"));
                Pomodoro.this.settingScene.setFill((Paint)Color.web((String)"#303030"));
                Pomodoro.this.btSetting.setGraphic((Node)new ImageView("setting-dark.png"));
                Pomodoro.this.btSetting.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.web((String)"#303030"), null, null)}));
                Pomodoro.this.lbStatus.setTextFill((Paint)Color.web((String)"#ababab"));
                Pomodoro.this.lbSetting.setTextFill((Paint)Color.web((String)"#ababab"));
                Pomodoro.this.lbMins.setTextFill((Paint)Color.web((String)"#ababab"));
                Pomodoro.this.t1.setTextFill((Paint)Color.web((String)"#ababab"));
                Pomodoro.this.t2.setTextFill((Paint)Color.web((String)"#ababab"));
                Pomodoro.this.mb.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.web((String)"#424242"), null, null)}));
                Pomodoro.this.darkMode = true;
            } else {
                Pomodoro.this.primaryScene.setFill((Paint)Color.web((String)"#eee"));
                Pomodoro.this.settingScene.setFill((Paint)Color.web((String)"#eee"));
                Pomodoro.this.btSetting.setGraphic((Node)new ImageView("setting.png"));
                Pomodoro.this.btSetting.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.web((String)"#eee"), null, null)}));
                Pomodoro.this.lbStatus.setTextFill((Paint)Color.BLACK);
                Pomodoro.this.lbSetting.setTextFill((Paint)Color.BLACK);
                Pomodoro.this.lbMins.setTextFill((Paint)Color.BLACK);
                Pomodoro.this.t1.setTextFill((Paint)Color.BLACK);
                Pomodoro.this.t2.setTextFill((Paint)Color.BLACK);
                Pomodoro.this.mb.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.LIGHTGRAY, null, null)}));
                Pomodoro.this.darkMode = false;
            }
        }
    }

    private class NumberExcessiveException
    extends Exception {
        private NumberExcessiveException() {
        }
    }

    private class RunningTimerException
    extends Exception {
        private RunningTimerException() {
        }
    }

    private class ButtonEventHandler
    implements EventHandler<ActionEvent> {
        private ButtonEventHandler() {
        }

        public void handle(ActionEvent actionEvent) {
            Button button = (Button)actionEvent.getTarget();
            String string = button.getId();
            if (string.equals("play")) {
                Pomodoro.this.btPlay.setDisable(true);
                Pomodoro.this.running = true;
                Pomodoro.this.runnable = new MyRunnable();
                Pomodoro.this.thread = new Thread(Pomodoro.this.runnable);
                Pomodoro.this.thread.start();
            } else if (string.equals("reset")) {
                if (Pomodoro.this.thread != null) {
                    Pomodoro.this.running = false;
                }
                Pomodoro.this.counter = 0;
                Pomodoro.this.s = Pomodoro.this.timeleft - Pomodoro.this.counter;
                Pomodoro.this.hrs = Pomodoro.this.s / 60 / 60;
                Pomodoro.this.min = Pomodoro.this.s / 60 % 60;
                Pomodoro.this.sec = Pomodoro.this.s % 60;
                if (Pomodoro.this.hrs <= 0) {
                    Pomodoro.this.lbTime.setText(String.format("%02d:%02d", Pomodoro.this.min, Pomodoro.this.sec));
                } else {
                    Pomodoro.this.lbTime.setText(String.format("%02d:%02d:%02d", Pomodoro.this.hrs, Pomodoro.this.min, Pomodoro.this.sec));
                }
                Pomodoro.this.btPlay.setDisable(false);
            } else if (string.equals("setting")) {
                Pomodoro.this.mb = new MenuBar();
                Pomodoro.this.mb.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.LIGHTGRAY, null, null)}));
                Pomodoro.this.t1 = new Label("\u30c6\u30fc\u30de\u5909\u66f4");
                Pomodoro.this.t1.setStyle("-fx-font: 15px 'YuGothic Medium';");
                Pomodoro.this.t2 = new Label("\u30c0\u30fc\u30af\u30e2\u30fc\u30c9");
                Pomodoro.this.t2.setStyle("-fx-font: 15px 'YuGothic Medium';");
                Menu menu = new Menu("");
                menu.setGraphic((Node)Pomodoro.this.t1);
                Pomodoro.this.mi1 = new CheckMenuItem("");
                Pomodoro.this.mi1.setGraphic((Node)Pomodoro.this.t2);
                Pomodoro.this.t1.setTextFill((Paint)Color.BLACK);
                Pomodoro.this.t2.setTextFill((Paint)Color.BLACK);
                MyEventHandler myEventHandler = new MyEventHandler();
                menu.addEventHandler(ActionEvent.ANY, (EventHandler)myEventHandler);
                Pomodoro.this.lbSetting = new Label("\u30bf\u30a4\u30de\u30fc\u6642\u9593");
                Pomodoro.this.lbSetting.setFont(new Font("YuGothic Medium", 15.0));
                Pomodoro.this.lbMins = new Label("mins");
                Pomodoro.this.lbWarn = new Label("");
                Pomodoro.this.lbWarn.setFont(new Font("YuGothic Bold", 15.0));
                Button button2 = new Button("\u5b8c\u4e86");
                button2.setId("done");
                button2.addEventHandler(ActionEvent.ANY, (EventHandler)Pomodoro.this.bh);
                button2.setFont(new Font("YuGothic Medium", 15.0));
                Pomodoro.this.tf = new TextField();
                Pomodoro.this.tf.setPrefColumnCount(4);
                Pomodoro.this.tf.setText(String.valueOf(Pomodoro.this.initMin));
                Pomodoro.this.tf.setFont(new Font("YuGothic Medium", 15.0));
                ObservableList observableList = Pomodoro.this.mb.getMenus();
                observableList.add((Object)menu);
                ObservableList observableList2 = menu.getItems();
                observableList2.add((Object)Pomodoro.this.mi1);
                GridPane gridPane = new GridPane();
                gridPane.add((Node)Pomodoro.this.tf, 0, 0);
                gridPane.add((Node)Pomodoro.this.lbMins, 1, 0);
                gridPane.add((Node)button2, 2, 0);
                gridPane.setBackground(null);
                gridPane.setPadding(new Insets(0.0, 0.0, 25.0, 0.0));
                gridPane.setHgap(10.0);
                gridPane.setAlignment(Pos.CENTER);
                VBox vBox = new VBox();
                ObservableList observableList3 = vBox.getChildren();
                observableList3.add((Object)Pomodoro.this.lbSetting);
                observableList3.addAll((Object[])new Node[]{gridPane});
                observableList3.add((Object)Pomodoro.this.mb);
                observableList3.add((Object)Pomodoro.this.lbWarn);
                vBox.setBackground(null);
                vBox.setSpacing(20.0);
                vBox.setPadding(new Insets(5.0));
                vBox.setAlignment(Pos.TOP_CENTER);
                Pomodoro.this.settingScene = new Scene((Parent)vBox, 250.0, 250.0);
                Pomodoro.this.settingScene.setFill((Paint)Color.web((String)"#eee"));
                Pomodoro.this.settingStage = new Stage();
                Pomodoro.this.settingStage.setScene(Pomodoro.this.settingScene);
                Pomodoro.this.settingStage.setTitle("\u8a2d\u5b9a");
                Pomodoro.this.settingStage.setResizable(false);
                Pomodoro.this.settingStage.initOwner((Window)Pomodoro.this.primaryStage);
                Pomodoro.this.settingStage.initModality(Modality.WINDOW_MODAL);
                if (Pomodoro.this.darkMode) {
                    Pomodoro.this.primaryScene.setFill((Paint)Color.web((String)"#303030"));
                    Pomodoro.this.settingScene.setFill((Paint)Color.web((String)"#303030"));
                    Pomodoro.this.btSetting.setGraphic((Node)new ImageView("setting-dark.png"));
                    Pomodoro.this.btSetting.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.web((String)"#303030"), null, null)}));
                    Pomodoro.this.lbStatus.setTextFill((Paint)Color.web((String)"#ababab"));
                    Pomodoro.this.lbSetting.setTextFill((Paint)Color.web((String)"#ababab"));
                    Pomodoro.this.lbMins.setTextFill((Paint)Color.web((String)"#ababab"));
                    Pomodoro.this.t1.setTextFill((Paint)Color.web((String)"#ababab"));
                    Pomodoro.this.t2.setTextFill((Paint)Color.web((String)"#ababab"));
                    Pomodoro.this.mb.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.web((String)"#424242"), null, null)}));
                    Pomodoro.this.mi1.setSelected(true);
                }
                Pomodoro.this.settingStage.show();
            } else if (string.equals("done")) {
                try {
                    Pomodoro.this.min = Integer.parseInt(Pomodoro.this.tf.getText());
                    Pomodoro.this.initMin = Integer.parseInt(Pomodoro.this.tf.getText());
                    if (Pomodoro.this.thread != null && Pomodoro.this.thread.isAlive()) {
                        throw new RunningTimerException();
                    }
                    if (Pomodoro.this.min < 0) {
                        throw new NumberFormatException();
                    }
                    Pomodoro.this.tfCounter = Pomodoro.this.tf.getText().length();
                    if (Pomodoro.this.tfCounter > Pomodoro.this.checkLength) {
                        throw new NumberExcessiveException();
                    }
                    Pomodoro.this.timeleft = Pomodoro.this.min * 60;
                    Pomodoro.this.s = Pomodoro.this.timeleft - Pomodoro.this.counter;
                    Pomodoro.this.hrs = Pomodoro.this.s / 60 / 60;
                    Pomodoro.this.min = Pomodoro.this.s / 60 % 60;
                    Pomodoro.this.sec = Pomodoro.this.s % 60;
                    if (Pomodoro.this.hrs <= 0) {
                        Pomodoro.this.lbTime.setText(String.format("%02d:%02d", Pomodoro.this.min, Pomodoro.this.sec));
                    } else {
                        Pomodoro.this.lbTime.setText(String.format("%02d:%02d:%02d", Pomodoro.this.hrs, Pomodoro.this.min, Pomodoro.this.sec));
                    }
                    Pomodoro.this.settingStage.close();
                }
                catch (RunningTimerException runningTimerException) {
                    Pomodoro.this.lbWarn.setText("\u30bf\u30a4\u30de\u30fc\u3092\u30ea\u30bb\u30c3\u30c8\u3057\u3066\u304b\u3089\n\u8a2d\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044");
                    Pomodoro.this.lbWarn.setTextFill((Paint)Color.DEEPPINK);
                }
                catch (NumberFormatException numberFormatException) {
                    Pomodoro.this.lbWarn.setText("\u6b63\u306e\u6574\u6570\u3067\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044");
                    Pomodoro.this.lbWarn.setTextFill((Paint)Color.DEEPPINK);
                }
                catch (NumberExcessiveException numberExcessiveException) {
                    Pomodoro.this.lbWarn.setText("4\u6841\u4ee5\u5185\u3067\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044");
                    Pomodoro.this.lbWarn.setTextFill((Paint)Color.DEEPPINK);
                }
            }
        }
    }

    public class MyRunnable
    implements Runnable {
        @Override
        public void run() {
            do {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    System.out.println(interruptedException);
                }
                Pomodoro.this.counter++;
                Pomodoro.this.s = Pomodoro.this.timeleft - Pomodoro.this.counter;
                Pomodoro.this.hrs = Pomodoro.this.s / 60 / 60;
                Pomodoro.this.min = Pomodoro.this.s / 60 % 60;
                Pomodoro.this.sec = Pomodoro.this.s % 60;
                if (Pomodoro.this.hrs <= 0) {
                    Platform.runLater(() -> Pomodoro.this.lbTime.setText(String.format("%02d:%02d", Pomodoro.this.min, Pomodoro.this.sec)));
                } else {
                    Platform.runLater(() -> Pomodoro.this.lbTime.setText(String.format("%02d:%02d:%02d", Pomodoro.this.hrs, Pomodoro.this.min, Pomodoro.this.sec)));
                }
                if (Pomodoro.this.counter != Pomodoro.this.timeleft) continue;
                Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
                if (infoArray.length > 0) {
                    Pomodoro.this.audio = new AudioClip(new File("Ding.mp3").toURI().toString());
                    Pomodoro.this.audio.play();
                } else {
                    System.out.println("\u518d\u751f\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002\u30aa\u30fc\u30c7\u30a3\u30aa\u30c7\u30d0\u30a4\u30b9\u306e\u72b6\u614b\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    System.out.println(interruptedException);
                }
                Pomodoro.this.running = false;
            } while (Pomodoro.this.running);
            Pomodoro.this.counter = 0;
            Pomodoro.this.s = Pomodoro.this.timeleft - Pomodoro.this.counter;
            Pomodoro.this.hrs = Pomodoro.this.s / 60 / 60;
            Pomodoro.this.min = Pomodoro.this.s / 60 % 60;
            Pomodoro.this.sec = Pomodoro.this.s % 60;
            if (Pomodoro.this.hrs <= 0) {
                Platform.runLater(() -> Pomodoro.this.lbTime.setText(String.format("%02d:%02d", Pomodoro.this.min, Pomodoro.this.sec)));
            } else {
                Platform.runLater(() -> Pomodoro.this.lbTime.setText(String.format("%02d:%02d:%02d", Pomodoro.this.hrs, Pomodoro.this.min, Pomodoro.this.sec)));
            }
            Pomodoro.this.btPlay.setDisable(false);
        }
    }
}

