import javafx.application.*;
import javafx.scene.*;
import javafx.scene.layout.*;
import javafx.scene.control.*;
import javafx.scene.paint.*;
import javafx.scene.image.*;
import javafx.scene.effect.*;
import javafx.scene.text.*;
import javafx.scene.input.*;
import javafx.stage.*;
import javafx.event.*;
import javafx.geometry.*;
import javafx.collections.*;

public class Kadai1 extends Application
{
	private int count;
	private int[] posBomb;
	private int[][] map;
	private Image[] imgs;
	private ImageView[][] ivs;
	private Label msg;
	
	public void start(Stage stage) throws Exception
	{
		posBomb= new int[2];
		posBomb[0] = (int)(Math.random()*5);
		posBomb[1] = (int)(Math.random()*5);
		
		map = new int[5][5];
		
		imgs = new Image[5];
		for(int i=0; i<imgs.length; i++){
			imgs[i] = new Image(i+".png");
		}
		
		ivs = new ImageView[5][5];
		for(int j=0; j<ivs.length; j++){
			for(int i=0; i<ivs[j].length; i++){
				ivs[j][i] = new ImageView(imgs[map[j][i]]);
				ivs[j][i].setPreserveRatio(true);
				ivs[j][i].setFitWidth(50);
			}
		}
		
		Font ft = new Font("HGPSoeiPresenceEB",20);
		
		Label top = new Label("eă}X𖾂");
		top.setTextFill(Color.BLACK);
		top.setFont(ft);
		ImageView sh = new ImageView("tsuruhasi.png");
		sh.setPreserveRatio(true);
		sh.setFitWidth(30);
		top.setGraphic(sh);
		msg = new Label("ŏ͉^II");
		msg.setPrefHeight(50);
		msg.setTextFill(Color.BLUE);
		msg.setFont(ft);
		
		Button[][] board = new Button[5][5];
		for(int j=0; j<board.length; j++){
			for(int i=0; i<board[j].length; i++){
				board[j][i] = new Button();
				board[j][i].setGraphic(ivs[j][i]);
				board[j][i].setId(""+(j*10+i));
			}
		}
		
		MyEventHandler handler = new MyEventHandler();
		for(int j=0; j<board.length; j++){
			for(int i=0; i<board[j].length; i++){
				board[j][i].addEventHandler(ActionEvent.ANY, handler);
			}
		}
		
		GridPane gp = new GridPane();
		for(int j=0; j<board.length; j++){
			for(int i=0; i<board[j].length; i++){
				gp.add(board[j][i], i, j);
			}
		}
		
		gp.setBackground(null);
		
		VBox vb = new VBox();
		ObservableList<Node> lst = vb.getChildren();
		lst.add(top);
		lst.add(gp);
		lst.add(msg);
		vb.setBackground(null);
		vb.setSpacing(5);
		vb.setPadding(new Insets(5));
		
		Scene scene = new Scene(vb);
		scene.setFill(Color.LIGHTBLUE);
		
		stage.setScene(scene);
		stage.setTitle("}CXC[p[");
		stage.setResizable(false);
		
		stage.sizeToScene();
		
		stage.show();
	}
	
	private class MyEventHandler implements EventHandler<ActionEvent>
	{
		public void handle(ActionEvent e){
			Button bt = (Button)e.getTarget();
			
			int id = Integer.parseInt(bt.getId());
			int by = id/10;
			int bx = id - by*10;
			
			int tmpx = bx-posBomb[0];
			int tmpy = by-posBomb[1];
			
			if(count == 24 && map[by][bx] == 0){
				count++;
				map[by][bx] = 4;
				ivs[by][bx].setImage(imgs[map[by][bx]]);
				msg.setGraphic(null);
				msg.setText("߂łƂII\n~bVNAII");
			}
			else if(tmpx == 0 && tmpy == 0){
				if(map[by][bx] == 0){
					count = count+25;
					map[by][bx] = 2;
					ivs[by][bx].setImage(imgs[map[by][bx]]);
					msg.setGraphic(null);
					msg.setText("ӂ\n~bVs");
				}
				else{
					msg.setGraphic(null);
					msg.setText("I");
				}
			}
			else{
				if(map[by][bx] == 0){
					count++;
					map[by][bx] = 1;
					ivs[by][bx].setImage(imgs[map[by][bx]]);
					
					if(map[posBomb[1]][posBomb[0]] != 2){
						if(tmpx >= -1 && tmpx <= 1 && tmpy >= -1 && tmpy <= 1){
							map[by][bx] = 3;
							ivs[by][bx].setImage(imgs[map[by][bx]]);
							ImageView det = new ImageView("ase.png");
							det.setPreserveRatio(true);
							det.setFitWidth(35);
							msg.setGraphic(det);
							msg.setContentDisplay(ContentDisplay.RIGHT);
							msg.setText("Z[t\n@߂Ɋ댯");
						}
						else{
							msg.setGraphic(null);
							msg.setText("Z[t@S");
						}
					}
					else{
						if(tmpx >= -1 && tmpx <= 1 && tmpy >= -1 && tmpy <= 1){
							map[by][bx] = 3;
							ivs[by][bx].setImage(imgs[map[by][bx]]);
						}
						else{}	
						msg.setGraphic(null);
						msg.setText("N͎񂾂");
					}
				}
				else{
					msg.setGraphic(null);
					msg.setText("͊mFς݂");
				}
			}
		}
	}
	public static void main(String[] args)
	{
		launch(args);
	}
}
			
		