import javafx.application.*;
import javafx.scene.*;
import javafx.scene.layout.*;
import javafx.scene.control.*;
import javafx.scene.paint.*;
import javafx.scene.image.*;
import javafx.scene.effect.*;
import javafx.scene.text.*;
import javafx.scene.input.*;
import javafx.scene.canvas.*;
import javafx.scene.shape.*;
import javafx.stage.*;
import javafx.event.*;
import javafx.geometry.*;
import javafx.collections.*;

public class Report extends Application
{
	private TextField player1, player2;
	private Label label_turn, player1Count, player2Count;
	private Canvas cv, turn_canvas1, turn_canvas2;
	private GraphicsContext gc, turn_gc1, turn_gc2;
	private Color clr, board_color;
	private RadioMenuItem rmi[];
	private Stage myStage;
	private String name1, name2;
	private int mx1, mx2, my1, my2, turn, board_num;
	private int[][] state;
	
	public void start(Stage stage) throws Exception
	{
		// Xe[W̐ݒ
		myStage = stage;
		myMainScene();
	}
	
	// CV[̐錾^ݒ^\
	private void myMainScene()
	{
		// 
		board_color = Color.GREEN;
		board_num = 0;
		
		// j[o[̐
		MenuBar mb = new MenuBar();
		mb.setBackground(new Background(new BackgroundFill(Color.LIGHTGRAY, null, null)));
		
		// j[̐
		Menu m = new Menu("j[");
		
		// j[ڂ̐
		MenuItem mi1 = new MenuItem("I");
		mi1.setId("finish");
		
		// j[̑gݗ
		ObservableList<Menu> lstm = mb.getMenus();
		lstm.add(m);
		ObservableList<MenuItem> lstmi = m.getItems();
		lstmi.add(mi1);
		
		// x̐^ݒ
		Label title = new Label("o[V");
		Label label_player1 = new Label("Player1");
		Label label_player2 = new Label("Player2");
		title.setAlignment(Pos.CENTER);
		title.setFont(new Font(25));
		
		// C[Wr[̐
		ImageView icon1 = new ImageView("blackpiece.png");
		ImageView icon2 = new ImageView("whitepiece.png");
		
		// eLXgtB[h̐^ݒ
		player1 = new TextField();
		player2 = new TextField();
		player1.setPromptText("O");
		player2.setPromptText("O");
		
		// {^̐^ݒ
		Button next = new Button("Start");
		
		// Cxgnh̐^ݒ
		m.addEventHandler(ActionEvent.ANY, new myMenuHandler());
		next.addEventHandler(ActionEvent.ANY, new myButtonHandler());
		
		// CAEgHBox̐^ݒ
		HBox hb1 = new HBox();
		ObservableList<Node> lst = hb1.getChildren();
		lst.add(icon1);
		lst.add(title);
		lst.add(icon2);
		hb1.setAlignment(Pos.CENTER);
		HBox hb2 = new HBox();
		lst = hb2.getChildren();
		lst.add(label_player1);
		lst.add(player1);
		hb2.setAlignment(Pos.CENTER);
		hb2.setSpacing(10);
		HBox hb3 = new HBox();
		lst = hb3.getChildren();
		lst.add(label_player2);
		lst.add(player2);
		hb3.setAlignment(Pos.CENTER);
		hb3.setSpacing(10);
		
		// CAEgVBox̐^ݒ
		VBox vb = new VBox();
		lst = vb.getChildren();
		lst.add(hb1);
		lst.add(hb2);
		lst.add(hb3);
		lst.add(next);
		vb.setSpacing(15);
		vb.setPadding(new Insets(10));
		vb.setAlignment(Pos.CENTER);
		
		// CAEgBorderPane̐^ݒ
		BorderPane bp = new BorderPane();
		bp.setTop(mb);
		bp.setCenter(vb);
		bp.setBackground(null);
		
		// V[^Xe[W̐^ݒ^\
		Scene scene = new Scene(bp);
		scene.setFill(Color.YELLOWGREEN);
		myStage.setScene(scene);
		myStage.setTitle("o[V");
		myStage.setMinWidth(300);
		myStage.setMinHeight(250);
		myStage.setMaxWidth(300);
		myStage.setMaxHeight(250);
		myStage.show();
	}
	
	// Q[V[̐錾^ݒ^\
	private void myGameScene()
	{
		// j[o[̐
		MenuBar mb = new MenuBar();
		mb.setBackground(new Background(new BackgroundFill(Color.LIGHTGRAY, null, null)));
		
		// j[̐
		Menu m = new Menu("j[");
		
		// j[ڂ̐
		MenuItem mi[] = new MenuItem[4];
		mi[0] = new MenuItem("Đ");
		mi[1] = new SeparatorMenuItem();
		mi[2] = new MenuItem("^Cg");
		mi[3] = new MenuItem("I");
		mi[0].setId("restart");
		mi[2].setId("title");
		mi[3].setId("finish");
		
		// j[̑gݗ
		ObservableList<Menu> lstm = mb.getMenus();
		lstm.add(m);
		ObservableList<MenuItem> lstmi = m.getItems();
		lstmi.addAll(mi);
		
		// x̐^ݒ
		label_turn = new Label(name1 + "̔Ԃł");
		Label label_player[] = new Label[2];
		label_player[0] = new Label(name1);
		label_player[1] = new Label(name2);
		player1Count = new Label();
		player2Count = new Label();
		Label dummy = new Label();
		label_turn.setFont(new Font(20));
		for(int i = 0; i < label_player.length; i++)
		{
			label_player[i].setPrefSize(80, 15);
			label_player[i].setAlignment(Pos.CENTER);
			label_player[i].setFont(new Font(15));
		}
		label_player[0].setTextFill(Color.BLACK);
		label_player[0].setPrefSize(100, 0);
		label_player[0].setBackground(new Background(new BackgroundFill(Color.LIGHTBLUE, null, null)));
		label_player[1].setTextFill(Color.WHITE);
		label_player[1].setPrefSize(100, 0);
		label_player[1].setBackground(new Background(new BackgroundFill(Color.BLUE, null, null)));
		player1Count.setPrefSize(80, 15);
		player1Count.setAlignment(Pos.CENTER);
		player1Count.setTextFill(Color.BLACK);
		player1Count.setFont(new Font(20));
		player2Count.setPrefSize(80, 15);
		player2Count.setAlignment(Pos.CENTER);
		player2Count.setTextFill(Color.WHITE);
		player2Count.setFont(new Font(20));
		dummy.setPrefSize(240, 240);
		
		// LoX𐶐^ݒ
		turn_canvas1 = new Canvas(100, 45);
		turn_canvas2 = new Canvas(100, 45);
		turn_gc1 = turn_canvas1.getGraphicsContext2D();
		turn_gc2 = turn_canvas2.getGraphicsContext2D();
		
		// |bvAbvj[𐶐
		ContextMenu cm = new ContextMenu();
		
		// j[𐶐
		Menu cm1 = new Menu("Ֆʂ̐F");
		
		// j[ڂ𐶐
		rmi = new RadioMenuItem[5];
		rmi[0] = new RadioMenuItem("");
		rmi[1] = new RadioMenuItem("");
		rmi[2] = new RadioMenuItem("");
		rmi[3] = new RadioMenuItem("");
		rmi[4] = new RadioMenuItem("");
		rmi[0].setId("green");
		rmi[1].setId("yellow");
		rmi[2].setId("red");
		rmi[3].setId("blue");
		rmi[4].setId("purple");
		rmi[board_num].setSelected(true);
		
		// j[ڂ̃O[v𐶐^ݒ
		ToggleGroup tg = new ToggleGroup();
		for(int i = 0; i < rmi.length; i++)
			rmi[i].setToggleGroup(tg);
		
		// j[gݗ
		lstmi = cm.getItems();
		lstmi.add(cm1);
		lstmi = cm1.getItems();
		lstmi.addAll(rmi);
		dummy.setContextMenu(cm);
		
		// o[V̔Ֆʂ̐
		reversiGeneration();
		
		// Cxgnh̐^ݒ
		m.addEventHandler(ActionEvent.ANY, new myMenuHandler());
		for(int i = 0; i < rmi.length; i++)
			rmi[i].addEventHandler(ActionEvent.ANY, new myPopMenuHandler());
		dummy.addEventHandler(MouseEvent.ANY, new myMouseHandler());
		
		// CAEgVBox̐^ݒ
		VBox vb1 = new VBox();
		ObservableList<Node> lst = vb1.getChildren();
		lst.add(label_player[0]);
		lst.add(player1Count);
		vb1.setAlignment(Pos.TOP_CENTER);
		VBox vb2 = new VBox();
		lst = vb2.getChildren();
		lst.add(label_player[1]);
		lst.add(player2Count);
		vb2.setAlignment(Pos.TOP_CENTER);
		
		// CAEgStackPane̐^ݒ
		StackPane sp1 = new StackPane();
		lst = sp1.getChildren();
		lst.add(vb1);
		lst.add(turn_canvas1);
		sp1.setAlignment(Pos.TOP_CENTER);
		StackPane sp2 = new StackPane();
		lst = sp2.getChildren();
		lst.add(cv);
		lst.add(dummy);
		StackPane sp3 = new StackPane();
		lst = sp3.getChildren();
		lst.add(vb2);
		lst.add(turn_canvas2);
		sp3.setAlignment(Pos.TOP_CENTER);
		
		// CAEgHBox̐^ݒ
		HBox hb = new HBox();
		lst = hb.getChildren();
		lst.add(sp1);
		lst.add(sp2);
		lst.add(sp3);
		hb.setPadding(new Insets(0, 15, 15, 0));
		hb.setSpacing(15);
		
		// CAEgVBox̐^ݒ
		VBox vb3 = new VBox();
		lst = vb3.getChildren();
		lst.add(label_turn);
		lst.add(hb);
		vb3.setPadding(new Insets(15));
		vb3.setSpacing(15);
		vb3.setAlignment(Pos.CENTER);
		
		// CAEgBorderPane̐^ݒ
		BorderPane bp = new BorderPane();
		bp.setTop(mb);
		bp.setCenter(vb3);
		bp.setBackground(null);
		
		// V[^Xe[W̐^ݒ^\
		Scene scene = new Scene(bp);
		scene.setFill(Color.YELLOWGREEN);
		myStage.setScene(scene);
		myStage.setTitle("o[V");
		myStage.setMinWidth(520);
		myStage.setMinHeight(380);
		myStage.setMaxWidth(520);
		myStage.setMaxHeight(380);
		myStage.show();
	}
	
	// o[V̏Ֆʂ̐
	private void reversiGeneration()
	{
		// f[^̏
		turn = 1;
		state = new int[8][8];
		clr = Color.BLACK;
		turnCursor();
		
		// LoX̐^ݒ
		cv = new Canvas(240, 240);
		gc = cv.getGraphicsContext2D();
		
		// ŏ̋zu
		state[3][4] = 1;
		state[4][3] = 1;
		state[3][3] = 2;
		state[4][4] = 2;
		
		// Ֆʂ𐶐
		colorChange();
		
		// ̐\
		countShow();
	}
	
	// Ֆʂ̐Fς
	private void colorChange()
	{
		// Ֆʂ𐶐iFh肷j
		gc.setFill(board_color);
		gc.fillRect(0.0, 0.0, 240.0, 240.0);
		gc.setLineWidth(2);
		gc.setStroke(Color.BLACK);
		gc.strokeRect(0.0, 0.0, 240.0, 240.0);
		gc.setLineWidth(1);
		for(double l = 30.0; l < 240.0; l += 30.0){
			gc.strokeLine(l, 0.0, l, 240.0);
			gc.strokeLine(0.0, l, 240, l);
		}
		
		// ĕ`
		paintPieceForArray();
		
		// \ĕ`
		isPreOperation();
	}
	
	// z񂩂`悷郁\bh
	private void paintPieceForArray()
	{
		for(int i = 0; i < state[0].length; i++) {
			for(int j = 0; j < state.length; j++) {
				// \
				if(state[j][i] == 1)
				{
					gc.setFill(Color.BLACK);
					gc.fillOval(j * 30 + 3, i * 30 + 3, 24.0, 24.0);
				}
				// \
				if(state[j][i] == 2)
				{
					gc.setFill(Color.WHITE);
					gc.fillOval(j * 30 + 3, i * 30 + 3, 24.0, 24.0);
				}
			}
		}
	}
	
	// zu郁\bh
	private void putPiece()
	{
		int pass = 0;
		
		// }EXʒuƗʒuꏏȂ
		if(mx1 == mx2 && my1 == my2)
		{
			// NbNWɋȂ
			if(state[mx1][my1] == 0)
			{
				// zu\ǂ׉\Ȃzu
				if(isPossible(mx1, my1, true)){
					// ̔Ԃɍ킹ĐݒύX
					finish : do{
						if(turn == 1)
						{
							turn++;
							clr = Color.WHITE;
							label_turn.setText(name2 + "̔Ԃł");
						}
						else if(turn == 2)
						{
							turn--;
							clr = Color.BLACK;
							label_turn.setText(name1 + "̔Ԃł");
						}
						// vC[̃J[\ړ
						turnCursor();
						
						// ̐\
						countShow();
						
						// \\̌vZ񐔂CNg
						pass++;
						
						// ݂ɂꏊȂȂI
						if(pass == 3)
						{
							gameFinish();
							break finish;
						}
					// \\ĂȂ΃pXĂx\\
					} while(!isPreOperation());
				}
			}
		}
	}
	
	// `悷郁\bh
	private void paintPiece(int x, int y)
	{
		// 
		clearPiece(x, y);
		
		// `悷W̔zɃf[^i[
		if(clr == Color.BLACK)
			state[x][y] = 1;
		else if(clr == Color.WHITE)
			state[x][y] = 2;
		
		// ĕ`
		paintPieceForArray();
	}
	
	// \`悷郁\bh
	private void prePaintPiece(int x, int y)
	{
		gc.setFill(Color.GRAY);
		gc.fillOval(x * 30 + 10, y * 30 + 10, 10.0, 10.0);
	}
	
	// 郁\bh
	private void clearPiece(int x, int y)
	{
		gc.setFill(board_color);
		gc.fillOval(x * 30 + 2, y * 30 + 2, 26.0, 26.0);
	}
	
	// \vZ郁\bh
	private boolean isPreOperation()
	{
		boolean flag = false;
		
		// O̗\
		for(int i = 0; i < state[0].length; i++) {
			for(int j = 0; j < state.length; j++) {
				if(state[j][i] == 0)
					clearPiece(j, i);
			}
		}
		
		// \\
		for(int i = 0; i < state[0].length; i++) {
			for(int j = 0; j < state.length; j++) {
				if(isPossible(j, i, false) && state[j][i] == 0)
				{
					prePaintPiece(j, i);
					flag = true;
				}
			}
		}
		
		return flag;
	}
	
	// zu\ǂׂ郁\bh
	private boolean isPossible(int x, int y, boolean mode)
	{
		boolean flag = false;
		int i;
		
		// 𒲂ׂ
		finish :
		{
			for(i = 1; i <= x; i++)
			{
				// ܂͈̐FȂ
				if(state[x - i][y] == 0 || (i == 1 && state[x - 1][y] == turn))
					break finish;
				// ̐FȂ
				if(state[x - i][y] == turn)
				{
					// [hŋzu\\
					if(mode)
						for(int j = 0; j < i; j++)
							paintPiece(x - j, y);
					flag = true;
					break finish;
				}
			}
		}
		
		// E𒲂ׂ
		finish :
		{
			for(i = 1; i <= (7 - x); i++)
			{
				// ܂͈E̐FȂ
				if(state[x + i][y] == 0 || (i == 1 && state[x + 1][y] == turn))
					break finish;
				// ̐FȂ
				if(state[x + i][y] == turn)
				{
					// [hŋzu\\
					if(mode)
						for(int j = 0; j < i; j++)
							paintPiece(x + j, y);
					flag = true;
					break finish;
				}
			}
		}
		
		// 𒲂ׂ
		finish :
		{
			for(i = 1; i <= y; i++)
			{
				// ܂͈オ̐FȂ
				if(state[x][y - i] == 0 || (i == 1 && state[x][y - 1] == turn))
					break finish;
				// ̐FȂ
				if(state[x][y - i] == turn)
				{
					// [hŋzu\\
					if(mode)
						for(int j = 0; j < i; j++)
							paintPiece(x, y - j);
					flag = true;
					break finish;
				}
			}
		}
		
		// 𒲂ׂ
		finish :
		{
			for(i = 1; i <= (7 - y); i++)
			{
				// ܂͈̐FȂ
				if(state[x][y + i] == 0 || (i == 1 && state[x][y + 1] == turn))
					break finish;
				// ̐FȂ
				if(state[x][y + i] == turn)
				{
					// [hŋzu\\
					if(mode)
						for(int j = 0; j < i; j++)
							paintPiece(x, y + j);
					flag = true;
					break finish;
				}
			}
		}
		
		// 𒲂ׂ
		finish :
		{
			for(i = 1; i <= Math.min(x, y); i++)
			{
				// ܂͈オ̐FȂ
				if(state[x - i][y - i] == 0 || (i == 1 && state[x - 1][y - 1] == turn))
					break finish;
				// ̐FȂ
				if(state[x - i][y - i] == turn)
				{
					// [hŋzu\\
					if(mode)
						for(int j = 0; j < i; j++)
							paintPiece(x - j, y - j);
					flag = true;
					break finish;
				}
			}
		}
		
		// E𒲂ׂ
		finish :
		{
			for(i = 1; i <= Math.min(7 - x, y); i++)
			{
				// ܂͈Eオ̐FȂ
				if(state[x + i][y - i] == 0 || (i == 1 && state[x + 1][y - 1] == turn))
					break finish;
				// ̐FȂ
				if(state[x + i][y - i] == turn)
				{
					// [hŋzu\\
					if(mode)
						for(int j = 0; j < i; j++)
							paintPiece(x + j, y - j);
					flag = true;
					break finish;
				}
			}
		}
		
		// 𒲂ׂ
		finish :
		{
			for(i = 1; i <= Math.min(x, 7 - y); i++)
			{
				// ܂͈̐FȂ
				if(state[x - i][y + i] == 0 || (i == 1 && state[x - 1][y + 1] == turn))
					break finish;
				// ̐FȂ
				if(state[x - i][y + i] == turn)
				{
					// [hŋzu\\
					if(mode)
						for(int j = 0; j < i; j++)
							paintPiece(x - j, y + j);
					flag = true;
					break finish;
				}
			}
		}
		
		// E𒲂ׂ
		finish :
		{
			for(i = 1; i <= Math.min(7 - x, 7 - y); i++)
			{
				// ܂͈E̐FȂ
				if(state[x + i][y + i] == 0 || (i == 1 && state[x + 1][y + 1] == turn))
					break finish;
				// ̐FȂ
				if(state[x + i][y + i] == turn)
				{
					// [hŋzu\\
					if(mode)
						for(int j = 0; j < i; j++)
							paintPiece(x + j, y + j);
					flag = true;
					break finish;
				}
			}
		}
		
		return flag;
	}
	
	// Q[Is\bh
	private void gameFinish()
	{
		// ʂvZĕ\
		if(blackCount() > whiteCount())
			label_turn.setText(name1 + "̏I");
		else if(blackCount() < whiteCount())
			label_turn.setText(name2 + "̏I");
		else
			label_turn.setText("I");
		
		turn = 3;
		turnCursor();
	}
	
	// ̋𐔂
	private int blackCount()
	{
		int black = 0;
		// Ֆʂ̍̋JEg
		for(int i = 0; i < state[0].length; i++) {
			for(int j = 0; j < state.length; j++) {
				if(state[j][i] == 1)
					black++;
			}
		}
		
		return black;
	}
	
	// ̋𐔂
	private int whiteCount()
	{
		int white = 0;
		// Ֆʂ̔̋JEg
		for(int i = 0; i < state[0].length; i++) {
			for(int j = 0; j < state.length; j++) {
				if(state[j][i] == 2)
					white++;
			}
		}
		
		return white;
	}
	
	// \
	private void countShow()
	{
		// \
		player1Count.setText(String.valueOf(blackCount()));
		
		// \
		player2Count.setText(String.valueOf(whiteCount()));
	}
	
	// ݃^[̃vC[ɃJ[\킹
	private void turnCursor()
	{
		if(turn == 1)
		{
			// ň͂
			turn_gc1.setLineWidth(2);
			turn_gc1.setStroke(Color.RED);
			turn_gc1.strokeRect(0.0, 0.0, 100.0, 45.0);
			
			// ɂ
			turn_gc2.clearRect(0.0, 0.0, 100.0, 45.0);
		}
		else if(turn == 2)
		{
			// ň͂
			turn_gc2.setLineWidth(2);
			turn_gc2.setStroke(Color.RED);
			turn_gc2.strokeRect(0.0, 0.0, 100.0, 45.0);
			
			// ɂ
			turn_gc1.clearRect(0.0, 0.0, 100.0, 45.0);
		}
		else if(turn == 3)
		{
			// ɂ
			turn_gc1.clearRect(0.0, 0.0, 100.0, 45.0);
			turn_gc2.clearRect(0.0, 0.0, 100.0, 45.0);
		}
	}
	
	// Cxgnh(j[)NX̐錾
	private class myMenuHandler implements EventHandler<ActionEvent>
	{
		public void handle(ActionEvent e)
		{
			MenuItem mi = (MenuItem)e.getTarget();
			String str = mi.getId();
			
			// Đ킷
			if(str.equals("restart"))
			{
				// Ֆʂ̐FL
				for(int i = 0; i < rmi.length; i++)
				{
					if(rmi[i].isSelected())
						board_num = i;
				}
				myGameScene();
			}
			// CV[֑J
			if(str.equals("title")) myMainScene();
			// I
			if(str.equals("finish")) Platform.exit();
		}
	}
	
	// Cxgnh(|bvAbvj[)NX̐錾
	private class myPopMenuHandler implements EventHandler<ActionEvent>
	{
		public void handle(ActionEvent e)
		{
			RadioMenuItem rmi = (RadioMenuItem)e.getTarget();
			String str = rmi.getId();
			
			// ΐF
			if(str.equals("green"))
			{
				board_color = Color.GREEN;
				colorChange();
			}
			// F
			if(str.equals("yellow"))
			{
				board_color = Color.YELLOW;
				colorChange();
			}
			// ԐF
			if(str.equals("red"))
			{
				board_color = Color.RED;
				colorChange();
			}
			// F
			if(str.equals("blue"))
			{
				board_color = Color.BLUE;
				colorChange();
			}
			// F
			if(str.equals("purple"))
			{
				board_color = Color.PURPLE;
				colorChange();
			}
		}
	}
	
	// Cxgnh({^)NX̐錾
	private class myButtonHandler implements EventHandler<ActionEvent>
	{
		public void handle(ActionEvent e)
		{
			// vC[1̖O擾i󔒂̓ftHgl[ɂȂj
			String str = player1.getText().replace(" ", "");
			str = str.replace("@", "");
			if(str.equals(""))
				name1 = "player1";
			else
				name1 = player1.getText();
			
			// vC[2̖O擾i󔒂̓ftHgl[ɂȂj
			str = player2.getText().replace(" ", "");
			str = str.replace("@", "");
			if(str.equals(""))
				name2 = "player2";
			else
				name2 = player2.getText();
			
			// Q[V[֑J
			myGameScene();
		}
	}
	
	// Cxgnhi}EXjNX̐錾
	private class myMouseHandler implements EventHandler<MouseEvent>
	{
		public void handle(MouseEvent e)
		{
			// NbNWmċzu
			EventType<? extends MouseEvent> type = e.getEventType();
			e.getButton();
			if(type == MouseEvent.MOUSE_PRESSED && e.getButton() == MouseButton.PRIMARY)
			{
				mx1 = (int)(e.getX() / 30.0);
				my1 = (int)(e.getY() / 30.0);
			}
			if(type == MouseEvent.MOUSE_CLICKED && e.getButton() == MouseButton.PRIMARY)
			{
				mx2 = (int)(e.getX() / 30.0);
				my2 = (int)(e.getY() / 30.0);
				putPiece();
			}
		}
	}
	
	public static void main(String[] args)
	{
		launch(args);
	}
}
